/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.task;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.task.GetTasksByTicketFilter;
import com.zoho.desk.task.GetTasksFilter;
import com.zoho.desk.task.Task;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskAPI {
    private String mailId;

    private TaskAPI(String mailId) {
        this.mailId = mailId;
    }

    public static TaskAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new TaskAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Task updateTask(String taskId, Task task) {
        if (taskId == null) {
            throw new ZDeskException("taskId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks/" + taskId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(task.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Task task2 = new Task(new JSONObject(responseData));
            return task2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Task> getTasks(Integer from, Integer limit, APIConstants.Task.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Task.Include> includeSet, GetTasksFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Task.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Task> taskData = new ArrayList<Task>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Task taskRef = new Task(dataArray.getJSONObject(i));
                    taskData.add(taskRef);
                }
            }
            ArrayList<Task> arrayList = taskData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Task> getTasksByTicket(String ticketId, Integer from, Integer limit, APIConstants.Task.SortBy sortBy, boolean isAscending, GetTasksByTicketFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/tasks");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Task> taskData = new ArrayList<Task>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Task taskRef = new Task(dataArray.getJSONObject(i));
                    taskData.add(taskRef);
                }
            }
            ArrayList<Task> arrayList = taskData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Task createTask(Task task) {
        if (task.getSubject() == null) {
            throw new ZDeskException("subject is mandatory payload key");
        }
        if (task.getDepartmentId() == null) {
            throw new ZDeskException("departmentId is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(task.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Task task2 = new Task(new JSONObject(responseData));
            return task2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Task getTask(String taskId, EnumSet<APIConstants.Task.Include> includeSet) {
        Object value;
        if (taskId == null) {
            throw new ZDeskException("taskId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks/" + taskId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Task.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Task(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

