/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.task;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Reminder {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public Reminder() {
    }

    public Reminder(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getRelativeReminderInMin() {
        return (String)this.data.get("relativeReminderInMin");
    }

    public void setRelativeReminderInMin(String relativeReminderInMin) {
        this.data.put("relativeReminderInMin", relativeReminderInMin);
        this.update.add("relativeReminderInMin");
    }

    public List<AlertType> getAlertType() {
        ArrayList<AlertType> result = new ArrayList<AlertType>();
        List value = (List)this.data.get("alertType");
        if (value == null) {
            return null;
        }
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            String responseValue;
            switch (responseValue = (String)iterator.next()) {
                case "EMAIL": {
                    result.add(AlertType.EMAIL);
                    break;
                }
                case "POPUP": {
                    result.add(AlertType.POPUP);
                    break;
                }
                case "SMS": {
                    result.add(AlertType.SMS);
                }
            }
        }
        return result;
    }

    public void setAlertType(List<AlertType> alertType) {
        if (alertType != null) {
            ArrayList<String> payloadData = new ArrayList<String>();
            for (AlertType value : alertType) {
                payloadData.add(value.getValue());
            }
            this.data.put("alertType", payloadData);
            this.update.add("alertType");
        }
    }

    public ReminderType getReminderType() {
        String responseValue = (String)this.data.get("reminderType");
        ReminderType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "ABSOLUTE": {
                value = ReminderType.ABSOLUTE;
                break;
            }
            case "RELATIVE": {
                value = ReminderType.RELATIVE;
            }
        }
        return value;
    }

    public void setReminderType(ReminderType reminderType) {
        String value = null;
        if (reminderType != null) {
            value = reminderType.getValue();
        }
        this.data.put("reminderType", value);
        this.update.add("reminderType");
    }

    public Date getReminderTime() throws ZDeskException {
        try {
            String reminderTimeValue = (String)this.data.get("reminderTime");
            return reminderTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(reminderTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public void setReminderTime(Date reminderTime) {
        String time = null;
        if (reminderTime != null) {
            time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(reminderTime);
        }
        this.data.put("reminderTime", time);
        this.update.add("reminderTime");
    }

    private void setFieldValues(JSONObject reminderData) throws JSONException {
        Iterator itr = reminderData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = reminderData.get(key);
            if (reminderData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, reminderData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum ReminderType {
        ABSOLUTE("ABSOLUTE"),
        RELATIVE("RELATIVE");

        private String value;

        private ReminderType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum AlertType {
        EMAIL("EMAIL"),
        POPUP("POPUP"),
        SMS("SMS");

        private String value;

        private AlertType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

