/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.task;

import com.zoho.desk.init.Filter;

public class GetTasksFilter
extends Filter {
    private GetTasksFilter() {
    }

    public static class Builder {
        GetTasksFilter filter = new GetTasksFilter();

        public Builder setViewId(String viewId) {
            this.filter.setQueryParam("viewId", viewId);
            return this;
        }

        public Builder setDepartmentId(String departmentId) {
            this.filter.setQueryParam("departmentId", departmentId);
            return this;
        }

        public Builder setDueDate(DueDate dueDate) {
            this.filter.setQueryParam("dueDate", dueDate.getValue());
            return this;
        }

        public Builder setDepartmentIds(String departmentIds) {
            this.filter.setQueryParam("departmentIds", departmentIds);
            return this;
        }

        public Builder setAssignee(String assignee) {
            this.filter.setQueryParam("assignee", assignee);
            return this;
        }

        public Builder setIsCompleted(Boolean isCompleted) {
            this.filter.setQueryParam("isCompleted", isCompleted);
            return this;
        }

        public GetTasksFilter build() {
            return this.filter;
        }
    }

    public static enum DueDate {
        OVERDUE("Overdue"),
        TOMORROW("Tomorrow"),
        CURRENTWEEK("CurrentWeek"),
        CURRENTMONTH("CurrentMonth"),
        TODAY("Today");

        private String value;

        private DueDate(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

