/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.role;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.role.GetRolesFilter;
import com.zoho.desk.role.Role;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RoleAPI {
    private String mailId;

    private RoleAPI(String mailId) {
        this.mailId = mailId;
    }

    public static RoleAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new RoleAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Role updateRole(String roleId, Role role) {
        if (roleId == null) {
            throw new ZDeskException("roleId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/roles/" + roleId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(role.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Role role2 = new Role(new JSONObject(responseData));
            return role2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Role> getRolesByIds(List<String> roleIds) {
        StringBuilder requestURL = new StringBuilder("/api/v1/rolesByIds");
        if (roleIds != null) {
            String roleIdsStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            StringBuilder builder = new StringBuilder("roleIds=");
            for (int i = 0; i < roleIds.size(); ++i) {
                builder.append(roleIds.get(i));
                if (i == roleIds.size() - 1) continue;
                builder.append(",");
            }
            requestURL.append(roleIdsStr).append("roleIds=").append(builder.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Role> roleData = new ArrayList<Role>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Role roleRef = new Role(dataArray.getJSONObject(i));
                    roleData.add(roleRef);
                }
            }
            ArrayList<Role> arrayList = roleData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Role getRole(String roleId) {
        if (roleId == null) {
            throw new ZDeskException("roleId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/roles/" + roleId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Role role = new Role(new JSONObject(responseData));
            return role;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Role createRole(Role role) {
        if (role.getShareDataWithPeers() == null) {
            throw new ZDeskException("shareDataWithPeers is mandatory payload key");
        }
        if (role.getName() == null) {
            throw new ZDeskException("name is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/roles");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(role.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Role role2 = new Role(new JSONObject(responseData));
            return role2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Map<String, Object> getAgentsByRole(String roleId) {
        if (roleId == null) {
            throw new ZDeskException("roleId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/roles/" + roleId + "/agents");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            Map<String, Object> map = CommonUtil.toConvertJSONToMap(data);
            return map;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteRole(String roleId, String transferToRoleId) {
        if (roleId == null) {
            throw new ZDeskException("roleId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/roles/" + roleId + "/delete");
        if (transferToRoleId == null) {
            throw new ZDeskException("transferToRoleId is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("transferToRoleId", transferToRoleId);
        JSONObject payloadData = new JSONObject(inputData);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Role> getRoles(Integer from, Integer limit, GetRolesFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/roles");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Role> roleData = new ArrayList<Role>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Role roleRef = new Role(dataArray.getJSONObject(i));
                    roleData.add(roleRef);
                }
            }
            ArrayList<Role> arrayList = roleData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

