/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.profile;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.profile.GetAgentsByProfileFilter;
import com.zoho.desk.profile.Profile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfileAPI {
    private String mailId;

    private ProfileAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ProfileAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ProfileAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Profile updateProfile(String profileId, Profile profile) {
        if (profileId == null) {
            throw new ZDeskException("profileId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/profiles/" + profileId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(profile.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Profile profile2 = new Profile(new JSONObject(responseData));
            return profile2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteProfile(String profileId, String transferToProfileId) {
        if (profileId == null) {
            throw new ZDeskException("profileId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/profiles/" + profileId + "/delete");
        if (transferToProfileId == null) {
            throw new ZDeskException("transferToProfileId is mandatory payload key");
        }
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("transferToProfileId", transferToProfileId);
        JSONObject payloadData = new JSONObject(inputData);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Profile getProfile(String profileId) {
        if (profileId == null) {
            throw new ZDeskException("profileId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/profiles/" + profileId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Profile profile = new Profile(new JSONObject(responseData));
            return profile;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Profile getMyProfilePermissions() {
        StringBuilder requestURL = new StringBuilder("/api/v1/myProfilePermissions");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Profile profile = new Profile(new JSONObject(responseData));
            return profile;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Profile> getProfiles(Boolean defaultValue, Boolean visible, String searchStr) {
        StringBuilder requestURL = new StringBuilder("/api/v1/profiles");
        if (defaultValue != null) {
            String defaultValueStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(defaultValueStr).append("default=").append(defaultValue);
        }
        if (visible != null) {
            String visibleStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(visibleStr).append("visible=").append(visible);
        }
        if (searchStr != null) {
            String searchStrStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(searchStrStr).append("searchStr=").append(searchStr);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Profile> profileData = new ArrayList<Profile>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Profile profileRef = new Profile(dataArray.getJSONObject(i));
                    profileData.add(profileRef);
                }
            }
            ArrayList<Profile> arrayList = profileData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Agent> getAgentsByProfile(String profileId, GetAgentsByProfileFilter filter) {
        if (profileId == null) {
            throw new ZDeskException("profileId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/profiles/" + profileId + "/agents");
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Agent> agentData = new ArrayList<Agent>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Agent agentRef = new Agent(dataArray.getJSONObject(i));
                    agentData.add(agentRef);
                }
            }
            ArrayList<Agent> arrayList = agentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

