/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.profile;

import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.profile.Permissions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Profile {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("default", "isVisible");

    public Profile() {
    }

    public Profile(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Boolean getDefaultValue() {
        return (Boolean)this.data.get("default");
    }

    public void setDefaultValue(Boolean defaultValue) {
        this.data.put("default", defaultValue);
        this.update.add("default");
    }

    public Permissions getPermissions() {
        try {
            Map value = (Map)this.data.get("permissions");
            if (value == null) {
                return null;
            }
            return new Permissions(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setPermissions(Permissions permissions) {
        this.data.put("permissions", permissions);
        this.update.add("permissions");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public void setName(String name) {
        this.data.put("name", name);
        this.update.add("name");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public Boolean getIsVisible() {
        return (Boolean)this.data.get("isVisible");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Administrator": {
                value = Type.ADMINISTRATOR;
                break;
            }
            case "Light": {
                value = Type.LIGHT;
                break;
            }
            case "Portal": {
                value = Type.PORTAL;
                break;
            }
            case "Standard": {
                value = Type.STANDARD;
                break;
            }
            case "Custom": {
                value = Type.CUSTOM;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject profileData) throws JSONException {
        Iterator itr = profileData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = profileData.get(key);
            if (profileData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, profileData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Type {
        ADMINISTRATOR("Administrator"),
        LIGHT("Light"),
        PORTAL("Portal"),
        STANDARD("Standard"),
        CUSTOM("Custom");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

