/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.product;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.department.Department;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Product {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isDeleted");

    public Product() {
    }

    public Product(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getUnitPrice() {
        return (String)this.data.get("unitPrice");
    }

    public void setUnitPrice(String unitPrice) {
        this.data.put("unitPrice", unitPrice);
        this.update.add("unitPrice");
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Long getCfFieldAsLong(String label) {
        try {
            return this.getCf(label) != null ? Long.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Double getCfFieldAsDouble(String label) {
        try {
            return this.getCf(label) != null ? Double.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Integer getCfFieldAsInteger(String label) {
        try {
            return this.getCf(label) != null ? Integer.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Boolean getCfFieldAsBoolean(String label) {
        return this.getCf(label) != null ? Boolean.valueOf(this.getCf(label)) : null;
    }

    public List<String> getCfFieldAsList(String label) {
        return this.getCf(label) != null ? Arrays.asList(this.getCf(label).split(";")) : null;
    }

    public String getCf(String label) {
        Map cf;
        if (this.data.containsKey("cf") && (cf = (Map)this.data.get("cf")).containsKey(label)) {
            if (cf.get(label) != null) {
                return (String)cf.get(label);
            }
            return null;
        }
        return null;
    }

    public void setCf(String key, String value) {
        HashMap<String, String> cf = (HashMap<String, String>)this.data.get("cf");
        if (cf == null) {
            cf = new HashMap<String, String>();
        }
        cf.put(key, value);
        this.data.put("cf", cf);
        this.update.add("cf");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public List<String> getDepartmentIds() {
        return (List)this.data.get("departmentIds");
    }

    public void setDepartmentIds(List<String> departmentIds) {
        this.data.put("departmentIds", departmentIds);
        this.update.add("departmentIds");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public void setOwnerId(String ownerId) {
        this.data.put("ownerId", ownerId);
        this.update.add("ownerId");
    }

    public String getLayoutId() {
        return (String)this.data.get("layoutId");
    }

    public String getProductName() {
        return (String)this.data.get("productName");
    }

    public void setProductName(String productName) {
        this.data.put("productName", productName);
        this.update.add("productName");
    }

    public String getProductCategory() {
        return (String)this.data.get("productCategory");
    }

    public void setProductCategory(String productCategory) {
        this.data.put("productCategory", productCategory);
        this.update.add("productCategory");
    }

    public String getManufacturer() {
        return (String)this.data.get("manufacturer");
    }

    public void setManufacturer(String manufacturer) {
        this.data.put("manufacturer", manufacturer);
        this.update.add("manufacturer");
    }

    public String getProductCode() {
        return (String)this.data.get("productCode");
    }

    public void setProductCode(String productCode) {
        this.data.put("productCode", productCode);
        this.update.add("productCode");
    }

    public Boolean getIsDeleted() {
        return (Boolean)this.data.get("isDeleted");
    }

    public String getCreatedBy() {
        return (String)this.data.get("createdBy");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getModifiedBy() {
        return (String)this.data.get("modifiedBy");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Agent getOwner() {
        return (Agent)this.data.get("owner");
    }

    public List<Department> getDepartments() {
        return (List)this.data.get("departments");
    }

    private void setFieldValues(JSONObject productData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(productData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = productData.get(key);
            if (productData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, productData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject productData) throws JSONException {
        if (productData.has("owner")) {
            if (productData.isNull("owner")) {
                this.data.put("owner", null);
                productData.remove("owner");
            } else {
                Agent owner = new Agent(productData.getJSONObject("owner"));
                this.data.put("owner", owner);
                productData.remove("owner");
            }
        }
        if (productData.has("departments")) {
            if (productData.isNull("departments")) {
                this.data.put("departments", null);
                productData.remove("departments");
            } else {
                ArrayList<Department> departmentsList = new ArrayList<Department>();
                JSONArray array = productData.getJSONArray("departments");
                for (int i = 0; i < array.length(); ++i) {
                    Department departments = new Department(array.getJSONObject(i));
                    departmentsList.add(departments);
                }
                this.data.put("departments", departmentsList);
                productData.remove("departments");
            }
        }
        return productData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

