/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.organization;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.organization.GetOrganizationFilter;
import com.zoho.desk.organization.Organization;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrganizationAPI {
    private String mailId;

    private OrganizationAPI(String mailId) {
        this.mailId = mailId;
    }

    public static OrganizationAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new OrganizationAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Organization> getOrganizations() {
        StringBuilder requestURL = new StringBuilder("/api/v1/organizations");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Organization> organizationData = new ArrayList<Organization>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Organization organizationRef = new Organization(dataArray.getJSONObject(i));
                    organizationData.add(organizationRef);
                }
            }
            ArrayList<Organization> arrayList = organizationData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Organization getOrganization(String organizationId, GetOrganizationFilter filter) {
        if (organizationId == null) {
            throw new ZDeskException("organizationId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/organizations/" + organizationId);
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Organization organization = new Organization(new JSONObject(responseData));
            return organization;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

