/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.organization;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Organization {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isAdminInOrg", "isDefault");

    public Organization() {
    }

    public Organization(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getCountry() {
        return (String)this.data.get("country");
    }

    public String getCity() {
        return (String)this.data.get("city");
    }

    public String getCompanyName() {
        return (String)this.data.get("companyName");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public Edition getEdition() {
        String responseValue = (String)this.data.get("edition");
        Edition value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "NEW_FREE": {
                value = Edition.NEW_FREE;
                break;
            }
            case "ENTERPRISE": {
                value = Edition.ENTERPRISE;
                break;
            }
            case "PROFESSIONAL": {
                value = Edition.PROFESSIONAL;
                break;
            }
            case "FREE": {
                value = Edition.FREE;
            }
        }
        return value;
    }

    public String getEmployeeCount() {
        return (String)this.data.get("employeeCount");
    }

    public Boolean getIsAdminInOrg() {
        return (Boolean)this.data.get("isAdminInOrg");
    }

    public String getFaviconURL() {
        return (String)this.data.get("faviconURL");
    }

    public String getPortalName() {
        return (String)this.data.get("portalName");
    }

    public String getStreet() {
        return (String)this.data.get("street");
    }

    public String getCurrencyLocale() {
        return (String)this.data.get("currencyLocale");
    }

    public String getAlias() {
        return (String)this.data.get("alias");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getState() {
        return (String)this.data.get("state");
    }

    public String getFax() {
        return (String)this.data.get("fax");
    }

    public String getZip() {
        return (String)this.data.get("zip");
    }

    public String getWebsite() {
        return (String)this.data.get("website");
    }

    public String getOrganizationName() {
        return (String)this.data.get("organizationName");
    }

    public String getMobile() {
        return (String)this.data.get("mobile");
    }

    public String getCurrencySymbol() {
        return (String)this.data.get("currencySymbol");
    }

    public String getLogoURL() {
        return (String)this.data.get("logoURL");
    }

    public String getCustomDomain() {
        return (String)this.data.get("customDomain");
    }

    public Boolean getIsDefault() {
        return (Boolean)this.data.get("isDefault");
    }

    public String getPhoneNumber() {
        return (String)this.data.get("phoneNumber");
    }

    public String getPortalURL() {
        return (String)this.data.get("portalURL");
    }

    public String getPrimaryContact() {
        return (String)this.data.get("primaryContact");
    }

    private void setFieldValues(JSONObject organizationData) throws JSONException {
        Iterator itr = organizationData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = organizationData.get(key);
            if (organizationData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, organizationData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Edition {
        NEW_FREE("NEW_FREE"),
        ENTERPRISE("ENTERPRISE"),
        PROFESSIONAL("PROFESSIONAL"),
        FREE("FREE");

        private String value;

        private Edition(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

