/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.module;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.module.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModuleAPI {
    private String mailId;

    private ModuleAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ModuleAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ModuleAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Module> getMyModules() {
        StringBuilder requestURL = new StringBuilder("/api/v1/myAccessibleModules");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Module> moduleData = new ArrayList<Module>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Module moduleRef = new Module(dataArray.getJSONObject(i));
                    moduleData.add(moduleRef);
                }
            }
            ArrayList<Module> arrayList = moduleData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Module> getModules() {
        StringBuilder requestURL = new StringBuilder("/api/v1/modules");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Module> moduleData = new ArrayList<Module>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Module moduleRef = new Module(dataArray.getJSONObject(i));
                    moduleData.add(moduleRef);
                }
            }
            ArrayList<Module> arrayList = moduleData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

