/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.module;

import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.module.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Module {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public Module() {
    }

    public Module(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public List<Modules> getModules() {
        try {
            ArrayList<Modules> result = new ArrayList<Modules>();
            List value = (List)this.data.get("modules");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Modules(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    private void setFieldValues(JSONObject moduleData) throws JSONException {
        Iterator itr = moduleData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = moduleData.get(key);
            if (moduleData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, moduleData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

