/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.mailReplyAddress;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SmtpDetails {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public SmtpDetails() {
    }

    public SmtpDetails(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getPort() {
        return (String)this.data.get("port");
    }

    public String getHost() {
        return (String)this.data.get("host");
    }

    public String getUserName() {
        return (String)this.data.get("userName");
    }

    public ConnectionType getConnectionType() {
        String responseValue = (String)this.data.get("connectionType");
        ConnectionType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "PLAIN": {
                value = ConnectionType.PLAIN;
                break;
            }
            case "SSL": {
                value = ConnectionType.SSL;
                break;
            }
            case "TLS": {
                value = ConnectionType.TLS;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject smtpDetailsData) throws JSONException {
        Iterator itr = smtpDetailsData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = smtpDetailsData.get(key);
            if (smtpDetailsData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, smtpDetailsData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum ConnectionType {
        PLAIN("PLAIN"),
        SSL("SSL"),
        TLS("TLS");

        private String value;

        private ConnectionType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

