/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.mailReplyAddress;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.mailReplyAddress.GetReplyMailAddressesFilter;
import com.zoho.desk.mailReplyAddress.MailReplyAddress;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailReplyAddressAPI {
    private String mailId;

    private MailReplyAddressAPI(String mailId) {
        this.mailId = mailId;
    }

    public static MailReplyAddressAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new MailReplyAddressAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<MailReplyAddress> getReplyMailAddresses(Integer from, Integer limit, GetReplyMailAddressesFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/mailReplyAddress");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<MailReplyAddress> mailReplyAddressData = new ArrayList<MailReplyAddress>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    MailReplyAddress mailReplyAddressRef = new MailReplyAddress(dataArray.getJSONObject(i));
                    mailReplyAddressData.add(mailReplyAddressRef);
                }
            }
            ArrayList<MailReplyAddress> arrayList = mailReplyAddressData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

