/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.logger;

import com.zoho.desk.init.APIConstants;
import com.zoho.oauth.client.ZohoOAuthClient;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ZDLogger {
    private static Logger logger;

    public static void initLogger(ZohoOAuthClient client) {
        logger = Logger.getLogger(ZDLogger.class.getName());
        String minLogLevel = client.getConfigValue("minLogLevel");
        String logFilePath = client.getConfigValue("logFilePath");
        if (logFilePath != null) {
            try {
                FileHandler fh = new FileHandler(logFilePath, true);
                SimpleFormatter formatter = new SimpleFormatter();
                fh.setFormatter(formatter);
                logger.addHandler(fh);
                logger.setUseParentHandlers(false);
            }
            catch (IOException | SecurityException ex) {
                logger.log(Level.SEVERE, "Exception occur while initialize ZDLogger: ", ex);
                ex.printStackTrace();
            }
        }
        if (minLogLevel == null || !APIConstants.LOGGER_LEVELS.containsKey(minLogLevel)) {
            logger.setLevel(Level.WARNING);
        } else if (APIConstants.LOGGER_LEVELS.containsKey(minLogLevel)) {
            logger.setLevel(APIConstants.LOGGER_LEVELS.get(minLogLevel));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void logDebug(String message) {
        logger.log(Level.FINE, "ZohoDesk - " + message);
    }

    public static void logInfo(String message) {
        logger.log(Level.INFO, "ZohoDesk - " + message);
    }

    public static void logWarning(String message) {
        logger.log(Level.WARNING, "ZohoDesk - " + message);
    }

    public static void logError(String message) {
        logger.log(Level.SEVERE, "ZohoDesk - " + message);
    }

    public static void logError(Throwable ex) {
        ZDLogger.logError(ex, false);
    }

    public static void logError(Throwable ex, boolean printStackTrace) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement element = stacktrace[3];
        String className = element.getClassName();
        String methodName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        String methodClause = className + '.' + methodName + ':' + lineNumber;
        logger.log(Level.SEVERE, "ZohoDesk -  in " + methodClause + " ::: " + ex);
    }
}

