/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.layout;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.layout.GetLayoutsFilter;
import com.zoho.desk.layout.Layout;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LayoutAPI {
    private String mailId;

    private LayoutAPI(String mailId) {
        this.mailId = mailId;
    }

    public static LayoutAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new LayoutAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Layout> getLayouts(Integer from, Integer limit, GetLayoutsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/layouts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Layout> layoutData = new ArrayList<Layout>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Layout layoutRef = new Layout(dataArray.getJSONObject(i));
                    layoutData.add(layoutRef);
                }
            }
            ArrayList<Layout> arrayList = layoutData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Layout getMyForm(String layoutId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/myForm");
        if (layoutId != null) {
            String layoutIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(layoutIdStr).append("layoutId=").append(layoutId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Layout layout = new Layout(new JSONObject(responseData));
            return layout;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

