/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.layout;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.layout.LayoutProfiles;
import com.zoho.desk.layout.Sections;
import com.zoho.desk.logger.ZDLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Layout {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isStandardLayout", "hasLogo", "isDefaultLayout", "skipDeptAccessValidation");

    public Layout() {
    }

    public Layout(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Boolean getIsStandardLayout() {
        return (Boolean)this.data.get("isStandardLayout");
    }

    public Boolean getHasLogo() {
        return (Boolean)this.data.get("hasLogo");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public Module getModule() {
        String responseValue = (String)this.data.get("module");
        Module value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Products": {
                value = Module.PRODUCTS;
                break;
            }
            case "Tasks": {
                value = Module.TASKS;
                break;
            }
            case "Contacts": {
                value = Module.CONTACTS;
                break;
            }
            case "Events": {
                value = Module.EVENTS;
                break;
            }
            case "TimeEntry": {
                value = Module.TIMEENTRY;
                break;
            }
            case "Calls": {
                value = Module.CALLS;
                break;
            }
            case "Cases": {
                value = Module.CASES;
                break;
            }
            case "Accounts": {
                value = Module.ACCOUNTS;
                break;
            }
            case "Contracts": {
                value = Module.CONTRACTS;
            }
        }
        return value;
    }

    public String getLayoutDisplayName() {
        return (String)this.data.get("layoutDisplayName");
    }

    public Boolean getIsDefaultLayout() {
        return (Boolean)this.data.get("isDefaultLayout");
    }

    public List<Sections> getSections() {
        try {
            ArrayList<Sections> result = new ArrayList<Sections>();
            List value = (List)this.data.get("sections");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Sections(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getLayoutDesc() {
        return (String)this.data.get("layoutDesc");
    }

    public String getLayoutName() {
        return (String)this.data.get("layoutName");
    }

    public Boolean getSkipDeptAccessValidation() {
        return (Boolean)this.data.get("skipDeptAccessValidation");
    }

    public List<LayoutProfiles> getLayoutProfiles() {
        try {
            ArrayList<LayoutProfiles> result = new ArrayList<LayoutProfiles>();
            List value = (List)this.data.get("layoutProfiles");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new LayoutProfiles(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getCreatedBy() {
        return (String)this.data.get("createdBy");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getModifiedBy() {
        return (String)this.data.get("modifiedBy");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Status getStatus() {
        String responseValue = (String)this.data.get("status");
        Status value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "active": {
                value = Status.ACTIVE;
                break;
            }
            case "inactive": {
                value = Status.INACTIVE;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject layoutData) throws JSONException {
        Iterator itr = layoutData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = layoutData.get(key);
            if (layoutData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, layoutData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Module {
        PRODUCTS("Products"),
        TASKS("Tasks"),
        CONTACTS("Contacts"),
        EVENTS("Events"),
        TIMEENTRY("TimeEntry"),
        CALLS("Calls"),
        CASES("Cases"),
        ACCOUNTS("Accounts"),
        CONTRACTS("Contracts");

        private String value;

        private Module(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

