/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.layout;

import com.zoho.desk.init.Filter;

public class GetLayoutsFilter
extends Filter {
    private GetLayoutsFilter() {
    }

    public static class Builder {
        GetLayoutsFilter filter = new GetLayoutsFilter();

        public Builder setModule(Module module) {
            this.filter.setQueryParam("module", module.getValue());
            return this;
        }

        public Builder setDepartmentId(String departmentId) {
            this.filter.setQueryParam("departmentId", departmentId);
            return this;
        }

        public Builder setStatus(Status status) {
            this.filter.setQueryParam("status", status.getValue());
            return this;
        }

        public Builder setLayoutName(String layoutName) {
            this.filter.setQueryParam("layoutName", layoutName);
            return this;
        }

        public GetLayoutsFilter build() {
            return this.filter;
        }
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive"),
        ALL("all");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Module {
        TICKETS("tickets"),
        CONTACTS("contacts"),
        ACCOUNTS("accounts"),
        TASKS("tasks"),
        CALLS("calls"),
        EVENTS("events"),
        TIMEENTRY("timeEntry"),
        CONTRACTS("contracts"),
        PRODUCTS("products");

        private String value;

        private Module(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

