/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.layout;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Fields {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isCustomField", "isReadOnly", "isEncryptedField", "isSystemMandatory", "isRemovable", "isMandatory");

    public Fields() {
    }

    public Fields(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getDisplayLabel() {
        return (String)this.data.get("displayLabel");
    }

    public void setDisplayLabel(String displayLabel) {
        this.data.put("displayLabel", displayLabel);
        this.update.add("displayLabel");
    }

    public String getApiName() {
        return (String)this.data.get("apiName");
    }

    public void setApiName(String apiName) {
        this.data.put("apiName", apiName);
        this.update.add("apiName");
    }

    public Boolean getIsCustomField() {
        return (Boolean)this.data.get("isCustomField");
    }

    public void setIsCustomField(Boolean isCustomField) {
        this.data.put("isCustomField", isCustomField);
        this.update.add("isCustomField");
    }

    public Boolean getIsReadOnly() {
        return (Boolean)this.data.get("isReadOnly");
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.data.put("isReadOnly", isReadOnly);
        this.update.add("isReadOnly");
    }

    public Boolean getIsEncryptedField() {
        return (Boolean)this.data.get("isEncryptedField");
    }

    public void setIsEncryptedField(Boolean isEncryptedField) {
        this.data.put("isEncryptedField", isEncryptedField);
        this.update.add("isEncryptedField");
    }

    public Boolean getIsSystemMandatory() {
        return (Boolean)this.data.get("isSystemMandatory");
    }

    public void setIsSystemMandatory(Boolean isSystemMandatory) {
        this.data.put("isSystemMandatory", isSystemMandatory);
        this.update.add("isSystemMandatory");
    }

    public Boolean getIsRemovable() {
        return (Boolean)this.data.get("isRemovable");
    }

    public void setIsRemovable(Boolean isRemovable) {
        this.data.put("isRemovable", isRemovable);
        this.update.add("isRemovable");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public void setId(String id) {
        this.data.put("id", id);
        this.update.add("id");
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "URL": {
                value = Type.URL;
            }
        }
        return value;
    }

    public void setType(Type type) {
        String value = null;
        if (type != null) {
            value = type.getValue();
        }
        this.data.put("type", value);
        this.update.add("type");
    }

    public Boolean getIsMandatory() {
        return (Boolean)this.data.get("isMandatory");
    }

    public void setIsMandatory(Boolean isMandatory) {
        this.data.put("isMandatory", isMandatory);
        this.update.add("isMandatory");
    }

    public String getMaxLength() {
        return (String)this.data.get("maxLength");
    }

    public void setMaxLength(String maxLength) {
        this.data.put("maxLength", maxLength);
        this.update.add("maxLength");
    }

    private void setFieldValues(JSONObject fieldsData) throws JSONException {
        Iterator itr = fieldsData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = fieldsData.get(key);
            if (fieldsData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, fieldsData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Type {
        URL("URL");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

