/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.init;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.logger.ZDLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonUtil {
    public static Map<String, Object> toConvertJSONToMap(JSONObject input) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator itr = input.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (input.isNull(key)) {
                map.put(key, null);
                continue;
            }
            List<Object> value = input.get(key);
            if (value instanceof JSONArray) {
                value = CommonUtil.toConvertJSONToList((JSONArray)value);
            }
            if (value instanceof JSONObject) {
                value = CommonUtil.toConvertJSONToMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toConvertJSONToList(JSONArray input) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < input.length(); ++i) {
            List<Object> value = input.get(i);
            if (value instanceof JSONArray) {
                value = CommonUtil.toConvertJSONToList((JSONArray)value);
            }
            if (value instanceof JSONObject) {
                value = CommonUtil.toConvertJSONToMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static File toConvertStreamAsFile(InputStream responseStream) {
        try {
            String fileName = HttpClient.type == null ? "file.txt" : "file." + HttpClient.type;
            File responseFile = new File(fileName);
            byte[] buffer = new byte[2048];
            FileOutputStream output = new FileOutputStream(responseFile);
            while (responseStream.read(buffer) != -1) {
                ((OutputStream)output).write(buffer);
            }
            ((OutputStream)output).close();
            responseStream.close();
            return responseFile;
        }
        catch (IOException ex) {
            ZDLogger.logError("IOException occur during InputStream to File conversion");
            throw new ZDeskException(ex);
        }
    }
}

