/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.http;

import com.zoho.desk.exception.BadRequestException;
import com.zoho.desk.exception.ForbiddenException;
import com.zoho.desk.exception.IntegrationAdminErrorException;
import com.zoho.desk.exception.InternalServerErrorException;
import com.zoho.desk.exception.InvalidDataException;
import com.zoho.desk.exception.MethodNotAllowedException;
import com.zoho.desk.exception.OnlyLiveChatUserException;
import com.zoho.desk.exception.TooManyRequestException;
import com.zoho.desk.exception.URLNotFoundException;
import com.zoho.desk.exception.UnauthorizedException;
import com.zoho.desk.exception.UnprocessableEntityException;
import com.zoho.desk.exception.UnsupportedMediaTypeException;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.exception.ZDeskResponseException;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClient {
    private static final HttpClient HTTPINSTANCE = new HttpClient();
    private static final CloseableHttpClient CLIENT = HttpClient.getHttpClient();
    public static String type = null;

    private HttpClient() {
    }

    public static HttpClient getInstance() {
        return HTTPINSTANCE;
    }

    public InputStream callAPI(APIConstants.HttpMethods method, String requestURL, HttpEntity payload, String mailId) {
        try {
            HttpDelete requestObject = null;
            if (requestURL.indexOf("?") != -1) {
                requestURL = this.encodeURL(requestURL);
            }
            ZohoOAuthClient client = ZohoOAuthClient.getInstance();
            requestURL = client.getDeskURL() + requestURL;
            ZDLogger.logError("Requested URL: " + requestURL);
            switch (method) {
                case POST: {
                    HttpPost post = new HttpPost(requestURL);
                    post.setEntity(payload);
                    requestObject = post;
                    break;
                }
                case PATCH: {
                    HttpPatch patch = new HttpPatch(requestURL);
                    patch.setEntity(payload);
                    requestObject = patch;
                    break;
                }
                case PUT: {
                    HttpPut put = new HttpPut(requestURL);
                    put.setEntity(payload);
                    requestObject = put;
                    break;
                }
                case DELETE: {
                    requestObject = new HttpDelete(requestURL);
                    break;
                }
                default: {
                    requestObject = new HttpGet(requestURL);
                }
            }
            requestObject.setHeader("Authorization", "Zoho-oauthtoken " + client.getAccessToken(mailId));
            return this.getResponseData(CLIENT.execute((HttpUriRequest)requestObject));
        }
        catch (ZohoOAuthException ex) {
            ZDLogger.logError(ex.getMessage());
            throw new ZohoOAuthException(ex);
        }
        catch (Exception e) {
            ZDLogger.logError(e.getMessage());
            throw new ZDeskException(e);
        }
    }

    private String encodeURL(String requestURL) {
        String[] splitParams = requestURL.split("\\?");
        StringBuilder encodeURL = new StringBuilder(splitParams[0]).append("?");
        String[] queryParams = splitParams[1].split("&");
        for (int i = 0; i < queryParams.length; ++i) {
            String[] splitQueryParams = queryParams[i].split("=");
            encodeURL.append(splitQueryParams[0]).append("=").append(URLEncodedUtils.formatSegments((String[])new String[]{splitQueryParams[1]}).substring(1));
            if (i == queryParams.length - 1) continue;
            encodeURL.append("&");
        }
        return encodeURL.toString();
    }

    private InputStream getResponseData(CloseableHttpResponse response) throws IOException, ZDeskException {
        try {
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 204) {
                block15: for (Header header : response.getAllHeaders()) {
                    if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                    for (String contentType : header.getValue().split(";")) {
                        if (!contentType.contains("/")) continue;
                        type = contentType.split("/")[1];
                        break block15;
                    }
                    break;
                }
                return response.getEntity() != null ? response.getEntity().getContent() : new ByteArrayInputStream("{}".getBytes());
            }
            JSONObject errorResponseData = null;
            String errorCode = null;
            String message = null;
            try {
                errorResponseData = new JSONObject(new Scanner(response.getEntity().getContent()).useDelimiter("\\A").next());
                errorCode = errorResponseData.getString("errorCode");
                message = errorResponseData.getString("message");
            }
            catch (Exception e) {
                errorCode = "";
                message = "";
            }
            switch (response.getStatusLine().getStatusCode()) {
                case 400: {
                    throw new BadRequestException(errorCode, message);
                }
                case 401: {
                    throw new UnauthorizedException(errorCode, message);
                }
                case 403: {
                    throw new ForbiddenException(errorCode, message);
                }
                case 404: {
                    throw new URLNotFoundException(errorCode, message);
                }
                case 405: {
                    throw new MethodNotAllowedException(errorCode, message);
                }
                case 415: {
                    throw new UnsupportedMediaTypeException(errorCode, message);
                }
                case 422: {
                    if (errorCode.equalsIgnoreCase("INVALID_DATA")) {
                        JSONArray errors = errorResponseData.getJSONArray("errors");
                        throw new InvalidDataException(errorCode, errors.toString());
                    }
                    if (errorCode.equalsIgnoreCase("ONLY_LIVECHAT_USER")) {
                        throw new OnlyLiveChatUserException(errorCode, message + ", \"departmentIds\": " + errorResponseData.getJSONArray("departmentIds").toString());
                    }
                    if (errorCode.equalsIgnoreCase("INTEGRATION_ADMIN_ERROR")) {
                        throw new IntegrationAdminErrorException(errorCode, message + ", \"integration\": " + errorResponseData.getString("integration"));
                    }
                    throw new UnprocessableEntityException(errorCode, message);
                }
                case 429: {
                    throw new TooManyRequestException(errorCode, message);
                }
                case 500: {
                    throw new InternalServerErrorException(errorCode, message);
                }
            }
            throw new ZDeskResponseException(response.getStatusLine().getStatusCode(), errorCode, message);
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex.getMessage() + ", Content Type is: " + response.getEntity().getContentType());
            throw new ZDeskException(ex.getMessage() + ", Content Type is: " + response.getEntity().getContentType());
        }
    }

    private static CloseableHttpClient getHttpClient() {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setUserAgent("zohodesksdk-java/1.1.1");
            ZohoOAuthClient client = ZohoOAuthClient.getInstance();
            String timeout = client.getConfigValue("timeOut");
            if (timeout != null) {
                RequestConfig config = RequestConfig.custom().setConnectTimeout(Integer.parseInt(timeout)).setConnectionRequestTimeout(Integer.parseInt(timeout)).setSocketTimeout(Integer.parseInt(timeout)).build();
                httpClientBuilder.setDefaultRequestConfig(config);
            }
            if (client.getAllConfigs().containsKey("proxyHost") && client.getAllConfigs().containsKey("proxyPort")) {
                String proxyHost = client.getConfigValue("proxyHost");
                Integer proxyPort = Integer.valueOf(client.getConfigValue("proxyPort"));
                String proxyUserDomain = client.getConfigValue("proxyUserDomain");
                String proxyUser = client.getConfigValue("proxyUser");
                String proxyPassword = client.getConfigValue("proxyPassword");
                HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
                if (proxyUser != null && !proxyUser.isEmpty()) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new NTCredentials(proxyUser, proxyPassword, (String)null, proxyUserDomain));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                httpClientBuilder.setProxy(proxy);
                ZDLogger.logInfo("JAVA SDK Proxy settings - Host : " + proxyHost + " , Port : " + proxyPort + " , Domain : " + proxyUserDomain + " , Proxy User : " + proxyUser);
            }
            SSLContext sslContext = SSLContext.getDefault();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            return httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        }
        catch (NoSuchAlgorithmException ex) {
            ZDLogger.logError(ex.getMessage());
            return null;
        }
    }
}

