/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.helpcenter;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.helpcenter.Helpcenter;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HelpcenterAPI {
    private String mailId;

    private HelpcenterAPI(String mailId) {
        this.mailId = mailId;
    }

    public static HelpcenterAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new HelpcenterAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Helpcenter> getAllHelpCenters() {
        StringBuilder requestURL = new StringBuilder("/api/v1/helpCenters");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Helpcenter> helpcenterData = new ArrayList<Helpcenter>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Helpcenter helpcenterRef = new Helpcenter(dataArray.getJSONObject(i));
                    helpcenterData.add(helpcenterRef);
                }
            }
            ArrayList<Helpcenter> arrayList = helpcenterData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Helpcenter getHelpCenter(String helpcenterId) {
        if (helpcenterId == null) {
            throw new ZDeskException("helpcenterId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/helpCenters/" + helpcenterId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Helpcenter helpcenter = new Helpcenter(new JSONObject(responseData));
            return helpcenter;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

