/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.helpcenter;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.helpcenter.Domains;
import com.zoho.desk.helpcenter.HelpCenterLocales;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Helpcenter {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isMultilingualEnabled", "isDefault");

    public Helpcenter() {
    }

    public Helpcenter(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public List<Domains> getDomains() {
        try {
            ArrayList<Domains> result = new ArrayList<Domains>();
            List value = (List)this.data.get("domains");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Domains(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getLogoLinkBackUrl() {
        return (String)this.data.get("logoLinkBackUrl");
    }

    public List<String> getDepartmentIds() {
        return (List)this.data.get("departmentIds");
    }

    public Boolean getIsMultilingualEnabled() {
        return (Boolean)this.data.get("isMultilingualEnabled");
    }

    public String getUrl() {
        return (String)this.data.get("url");
    }

    public String getLogoUrl() {
        return (String)this.data.get("logoUrl");
    }

    public Boolean getIsDefault() {
        return (Boolean)this.data.get("isDefault");
    }

    public Date getSiteMapUpdatedTime() throws ZDeskException {
        try {
            String siteMapUpdatedTimeValue = (String)this.data.get("siteMapUpdatedTime");
            return siteMapUpdatedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(siteMapUpdatedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public String getFavIconUrl() {
        return (String)this.data.get("favIconUrl");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public List<HelpCenterLocales> getHelpCenterLocales() {
        try {
            ArrayList<HelpCenterLocales> result = new ArrayList<HelpCenterLocales>();
            List value = (List)this.data.get("helpCenterLocales");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new HelpCenterLocales(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getPrimaryLocale() {
        return (String)this.data.get("primaryLocale");
    }

    public String getStatus() {
        return (String)this.data.get("status");
    }

    private void setFieldValues(JSONObject helpcenterData) throws JSONException {
        Iterator itr = helpcenterData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = helpcenterData.get(key);
            if (helpcenterData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, helpcenterData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

