/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.field;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.field.Field;
import com.zoho.desk.fieldPermission.FieldPermission;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FieldAPI {
    private String mailId;

    private FieldAPI(String mailId) {
        this.mailId = mailId;
    }

    public static FieldAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new FieldAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Field> getFields(Module module, List<String> apiNames) {
        StringBuilder requestURL = new StringBuilder("/api/v1/organizationFields");
        if (module != null) {
            String moduleStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(moduleStr).append("module=").append(module.getValue());
        }
        if (apiNames != null) {
            String apiNamesStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            StringBuilder builder = new StringBuilder("apiNames=");
            for (int i = 0; i < apiNames.size(); ++i) {
                builder.append(apiNames.get(i));
                if (i == apiNames.size() - 1) continue;
                builder.append(",");
            }
            requestURL.append(apiNamesStr).append("apiNames=").append(builder.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Field> fieldData = new ArrayList<Field>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Field fieldRef = new Field(dataArray.getJSONObject(i));
                    fieldData.add(fieldRef);
                }
            }
            ArrayList<Field> arrayList = fieldData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<FieldPermission> getFieldPermissions(String fieldId) {
        if (fieldId == null) {
            throw new ZDeskException("fieldId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/organizationFields/" + fieldId + "/permissions");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<FieldPermission> fieldPermissionData = new ArrayList<FieldPermission>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    FieldPermission fieldPermissionRef = new FieldPermission(dataArray.getJSONObject(i));
                    fieldPermissionData.add(fieldPermissionRef);
                }
            }
            ArrayList<FieldPermission> arrayList = fieldPermissionData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public static enum Module {
        TICKETS("tickets"),
        CALLS("calls"),
        ACCOUNTS("accounts"),
        TIMEENTRY("timeEntry"),
        CONTRACTS("contracts"),
        CONTACTS("contacts"),
        TASKS("tasks"),
        EVENTS("events"),
        PRODUCTS("products");

        private String value;

        private Module(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

