/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.field;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Field {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isCustomField", "showToHelpCenter", "isReadOnly", "isEncryptedField", "isMandatory");

    public Field() {
    }

    public Field(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getDisplayLabel() {
        return (String)this.data.get("displayLabel");
    }

    public List<String> getAllowedValues() {
        return (List)this.data.get("allowedValues");
    }

    public String getApiName() {
        return (String)this.data.get("apiName");
    }

    public Boolean getIsCustomField() {
        return (Boolean)this.data.get("isCustomField");
    }

    public Boolean getShowToHelpCenter() {
        return (Boolean)this.data.get("showToHelpCenter");
    }

    public DefaultValue getDefaultValue() {
        String responseValue = (String)this.data.get("defaultValue");
        DefaultValue value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "true": {
                value = DefaultValue.TRUE;
                break;
            }
            case "false": {
                value = DefaultValue.FALSE;
            }
        }
        return value;
    }

    public String getRoundingPrecision() {
        return (String)this.data.get("roundingPrecision");
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Email": {
                value = Type.EMAIL;
                break;
            }
            case "Percent": {
                value = Type.PERCENT;
                break;
            }
            case "Text": {
                value = Type.TEXT;
                break;
            }
            case "Picklist": {
                value = Type.PICKLIST;
                break;
            }
            case "URL": {
                value = Type.URL;
                break;
            }
            case "Date": {
                value = Type.DATE;
                break;
            }
            case "DateTime": {
                value = Type.DATETIME;
                break;
            }
            case "Textarea": {
                value = Type.TEXTAREA;
                break;
            }
            case "Decimal": {
                value = Type.DECIMAL;
                break;
            }
            case "Number": {
                value = Type.NUMBER;
                break;
            }
            case "Phone": {
                value = Type.PHONE;
                break;
            }
            case "Currency": {
                value = Type.CURRENCY;
                break;
            }
            case "LookUp": {
                value = Type.LOOKUP;
                break;
            }
            case "Multiselect": {
                value = Type.MULTISELECT;
                break;
            }
            case "Boolean": {
                value = Type.BOOLEAN;
                break;
            }
            case "Fax": {
                value = Type.FAX;
                break;
            }
            case "AutoNumber": {
                value = Type.AUTONUMBER;
            }
        }
        return value;
    }

    public Boolean getIsReadOnly() {
        return (Boolean)this.data.get("isReadOnly");
    }

    public String getDecimalPlaces() {
        return (String)this.data.get("decimalPlaces");
    }

    public RoundingOption getRoundingOption() {
        String responseValue = (String)this.data.get("roundingOption");
        RoundingOption value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "normal": {
                value = RoundingOption.NORMAL;
                break;
            }
            case "roundDown": {
                value = RoundingOption.ROUNDDOWN;
                break;
            }
            case "roundOff": {
                value = RoundingOption.ROUNDOFF;
                break;
            }
            case "roundUp": {
                value = RoundingOption.ROUNDUP;
            }
        }
        return value;
    }

    public Boolean getIsEncryptedField() {
        return (Boolean)this.data.get("isEncryptedField");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Boolean getIsMandatory() {
        return (Boolean)this.data.get("isMandatory");
    }

    public String getMaxLength() {
        return (String)this.data.get("maxLength");
    }

    private void setFieldValues(JSONObject fieldData) throws JSONException {
        Iterator itr = fieldData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = fieldData.get(key);
            if (fieldData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, fieldData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum RoundingOption {
        NORMAL("normal"),
        ROUNDDOWN("roundDown"),
        ROUNDOFF("roundOff"),
        ROUNDUP("roundUp");

        private String value;

        private RoundingOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Type {
        EMAIL("Email"),
        PERCENT("Percent"),
        TEXT("Text"),
        PICKLIST("Picklist"),
        URL("URL"),
        DATE("Date"),
        DATETIME("DateTime"),
        TEXTAREA("Textarea"),
        DECIMAL("Decimal"),
        NUMBER("Number"),
        PHONE("Phone"),
        CURRENCY("Currency"),
        LOOKUP("LookUp"),
        MULTISELECT("Multiselect"),
        BOOLEAN("Boolean"),
        FAX("Fax"),
        AUTONUMBER("AutoNumber");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum DefaultValue {
        TRUE("true"),
        FALSE("false");

        private String value;

        private DefaultValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

