/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.event;

import com.zoho.desk.init.Filter;

public class GetEventsFilter
extends Filter {
    private GetEventsFilter() {
    }

    public static class Builder {
        GetEventsFilter filter = new GetEventsFilter();

        public Builder setViewId(String viewId) {
            this.filter.setQueryParam("viewId", viewId);
            return this;
        }

        public Builder setDepartmentId(String departmentId) {
            this.filter.setQueryParam("departmentId", departmentId);
            return this;
        }

        public Builder setStartTime(StartTime startTime) {
            this.filter.setQueryParam("startTime", startTime.getValue());
            return this;
        }

        public Builder setDepartmentIds(String departmentIds) {
            this.filter.setQueryParam("departmentIds", departmentIds);
            return this;
        }

        public Builder setAssignee(String assignee) {
            this.filter.setQueryParam("assignee", assignee);
            return this;
        }

        public Builder setIsCompleted(Boolean isCompleted) {
            this.filter.setQueryParam("isCompleted", isCompleted);
            return this;
        }

        public GetEventsFilter build() {
            return this.filter;
        }
    }

    public static enum StartTime {
        OVERDUE("Overdue"),
        TOMORROW("Tomorrow"),
        CURRENTWEEK("CurrentWeek"),
        CURRENTMONTH("CurrentMonth"),
        TODAY("Today");

        private String value;

        private StartTime(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

