/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.event;

import com.zoho.desk.event.Event;
import com.zoho.desk.event.GetEventsByTicketFilter;
import com.zoho.desk.event.GetEventsFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventAPI {
    private String mailId;

    private EventAPI(String mailId) {
        this.mailId = mailId;
    }

    public static EventAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new EventAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Event getEvent(String eventId, EnumSet<APIConstants.Event.Include> includeSet) {
        Object value;
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Event.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Event(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Event> getEvents(Integer from, Integer limit, APIConstants.Event.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Event.Include> includeSet, GetEventsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/events");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Event.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Event> eventData = new ArrayList<Event>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Event eventRef = new Event(dataArray.getJSONObject(i));
                    eventData.add(eventRef);
                }
            }
            ArrayList<Event> arrayList = eventData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Event updateEvent(String eventId, Event event) {
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(event.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Event event2 = new Event(new JSONObject(responseData));
            return event2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean moveToTrash(List<String> entityIds) {
        if (entityIds == null) {
            throw new ZDeskException("entityIds is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("entityIds", entityIds);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/events/moveToTrash");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Event> getEventsByTicket(String ticketId, Integer from, Integer limit, APIConstants.Event.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Event.Include> includeSet, GetEventsByTicketFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/events");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Event.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Event> eventData = new ArrayList<Event>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Event eventRef = new Event(dataArray.getJSONObject(i));
                    eventData.add(eventRef);
                }
            }
            ArrayList<Event> arrayList = eventData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Event createEvent(Event event) {
        if (event.getContactId() == null) {
            throw new ZDeskException("contactId is mandatory payload key");
        }
        if (event.getSubject() == null) {
            throw new ZDeskException("subject is mandatory payload key");
        }
        if (event.getDepartmentId() == null) {
            throw new ZDeskException("departmentId is mandatory payload key");
        }
        if (event.getDuration() == null) {
            throw new ZDeskException("duration is mandatory payload key");
        }
        if (event.getStartTime() == null) {
            throw new ZDeskException("startTime is mandatory payload key");
        }
        if (event.getCategory() == null) {
            throw new ZDeskException("category is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(event.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Event event2 = new Event(new JSONObject(responseData));
            return event2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

