/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.event;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.contact.Contact;
import com.zoho.desk.event.ModifiedBy;
import com.zoho.desk.event.Reminder;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.team.Team;
import com.zoho.desk.ticket.Ticket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Event {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isCommented");

    public Event() {
    }

    public Event(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Date getCompletedTime() throws ZDeskException {
        try {
            String completedTimeValue = (String)this.data.get("completedTime");
            return completedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(completedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getSubject() {
        return (String)this.data.get("subject");
    }

    public void setSubject(String subject) {
        this.data.put("subject", subject);
        this.update.add("subject");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public void setDepartmentId(String departmentId) {
        this.data.put("departmentId", departmentId);
        this.update.add("departmentId");
    }

    public String getCreatorId() {
        return (String)this.data.get("creatorId");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public void setOwnerId(String ownerId) {
        this.data.put("ownerId", ownerId);
        this.update.add("ownerId");
    }

    public String getSecId() {
        return (String)this.data.get("secId");
    }

    public String getDuration() {
        return (String)this.data.get("duration");
    }

    public void setDuration(String duration) {
        this.data.put("duration", duration);
        this.update.add("duration");
    }

    public Boolean getIsCommented() {
        return (Boolean)this.data.get("isCommented");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public ModifiedBy getModifiedBy() {
        try {
            Map value = (Map)this.data.get("modifiedBy");
            if (value == null) {
                return null;
            }
            return new ModifiedBy(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public Date getStartTime() throws ZDeskException {
        try {
            String startTimeValue = (String)this.data.get("startTime");
            return startTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(startTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public void setStartTime(Date startTime) {
        String time = null;
        if (startTime != null) {
            time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(startTime);
        }
        this.data.put("startTime", time);
        this.update.add("startTime");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Long getCfFieldAsLong(String label) {
        try {
            return this.getCf(label) != null ? Long.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Double getCfFieldAsDouble(String label) {
        try {
            return this.getCf(label) != null ? Double.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Integer getCfFieldAsInteger(String label) {
        try {
            return this.getCf(label) != null ? Integer.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Boolean getCfFieldAsBoolean(String label) {
        return this.getCf(label) != null ? Boolean.valueOf(this.getCf(label)) : null;
    }

    public List<String> getCfFieldAsList(String label) {
        return this.getCf(label) != null ? Arrays.asList(this.getCf(label).split(";")) : null;
    }

    public String getCf(String label) {
        Map cf;
        if (this.data.containsKey("cf") && (cf = (Map)this.data.get("cf")).containsKey(label)) {
            if (cf.get(label) != null) {
                return (String)cf.get(label);
            }
            return null;
        }
        return null;
    }

    public void setCf(String key, String value) {
        HashMap<String, String> cf = (HashMap<String, String>)this.data.get("cf");
        if (cf == null) {
            cf = new HashMap<String, String>();
        }
        cf.put(key, value);
        this.data.put("cf", cf);
        this.update.add("cf");
    }

    public List<Reminder> getReminder() {
        try {
            ArrayList<Reminder> result = new ArrayList<Reminder>();
            List value = (List)this.data.get("reminder");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Reminder(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setReminder(List<Reminder> reminder) {
        this.data.put("reminder", reminder);
        this.update.add("reminder");
    }

    public String getContactId() {
        return (String)this.data.get("contactId");
    }

    public void setContactId(String contactId) {
        this.data.put("contactId", contactId);
        this.update.add("contactId");
    }

    public String getPriority() {
        return (String)this.data.get("priority");
    }

    public void setPriority(String priority) {
        this.data.put("priority", priority);
        this.update.add("priority");
    }

    public String getLayoutId() {
        return (String)this.data.get("layoutId");
    }

    public String getWebUrl() {
        return (String)this.data.get("webUrl");
    }

    public void setWebUrl(String webUrl) {
        this.data.put("webUrl", webUrl);
        this.update.add("webUrl");
    }

    public String getTeamId() {
        return (String)this.data.get("teamId");
    }

    public String getCategory() {
        return (String)this.data.get("category");
    }

    public void setCategory(String category) {
        this.data.put("category", category);
        this.update.add("category");
    }

    public String getTicketId() {
        return (String)this.data.get("ticketId");
    }

    public void setTicketId(String ticketId) {
        this.data.put("ticketId", ticketId);
        this.update.add("ticketId");
    }

    public String getStatus() {
        return (String)this.data.get("status");
    }

    public void setStatus(String status) {
        this.data.put("status", status);
        this.update.add("status");
    }

    public Ticket getTicket() {
        return (Ticket)this.data.get("ticket");
    }

    public Contact getContact() {
        return (Contact)this.data.get("contact");
    }

    public Agent getAssignee() {
        return (Agent)this.data.get("assignee");
    }

    public Team getTeam() {
        return (Team)this.data.get("team");
    }

    private void setFieldValues(JSONObject eventData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(eventData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = eventData.get(key);
            if (eventData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, eventData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject eventData) throws JSONException {
        if (eventData.has("ticket")) {
            if (eventData.isNull("ticket")) {
                this.data.put("ticket", null);
                eventData.remove("ticket");
            } else {
                Ticket ticket = new Ticket(eventData.getJSONObject("ticket"));
                this.data.put("ticket", ticket);
                eventData.remove("ticket");
            }
        }
        if (eventData.has("contact")) {
            if (eventData.isNull("contact")) {
                this.data.put("contact", null);
                eventData.remove("contact");
            } else {
                Contact contact = new Contact(eventData.getJSONObject("contact"));
                this.data.put("contact", contact);
                eventData.remove("contact");
            }
        }
        if (eventData.has("assignee")) {
            if (eventData.isNull("assignee")) {
                this.data.put("assignee", null);
                eventData.remove("assignee");
            } else {
                Agent assignee = new Agent(eventData.getJSONObject("assignee"));
                this.data.put("assignee", assignee);
                eventData.remove("assignee");
            }
        }
        if (eventData.has("team")) {
            if (eventData.isNull("team")) {
                this.data.put("team", null);
                eventData.remove("team");
            } else {
                Team team = new Team(eventData.getJSONObject("team"));
                this.data.put("team", team);
                eventData.remove("team");
            }
        }
        return eventData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

