/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.department;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.department.Department;
import com.zoho.desk.department.GetAgentsInDepartmentFilter;
import com.zoho.desk.department.GetDepartmentsFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DepartmentAPI {
    private String mailId;

    private DepartmentAPI(String mailId) {
        this.mailId = mailId;
    }

    public static DepartmentAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new DepartmentAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Department getDepartment(String departmentId) {
        if (departmentId == null) {
            throw new ZDeskException("departmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/departments/" + departmentId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Department department = new Department(new JSONObject(responseData));
            return department;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Agent> getAgentsInDepartment(String departmentId, Integer from, Integer limit, GetAgentsInDepartmentFilter filter) {
        if (departmentId == null) {
            throw new ZDeskException("departmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/departments/" + departmentId + "/agents");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Agent> agentData = new ArrayList<Agent>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Agent agentRef = new Agent(dataArray.getJSONObject(i));
                    agentData.add(agentRef);
                }
            }
            ArrayList<Agent> arrayList = agentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Department updateDepartment(String departmentId, Department department) {
        if (departmentId == null) {
            throw new ZDeskException("departmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/departments/" + departmentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(department.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Department department2 = new Department(new JSONObject(responseData));
            return department2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Department createDepartment(Department department) {
        if (department.getName() == null) {
            throw new ZDeskException("name is mandatory payload key");
        }
        if (department.getAssociatedAgentIds() == null) {
            throw new ZDeskException("associatedAgentIds is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/departments");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(department.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Department department2 = new Department(new JSONObject(responseData));
            return department2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Department> getDepartments(Integer from, Integer limit, GetDepartmentsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/departments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Department> departmentData = new ArrayList<Department>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Department departmentRef = new Department(dataArray.getJSONObject(i));
                    departmentData.add(departmentRef);
                }
            }
            ArrayList<Department> arrayList = departmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

