/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.department;

import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Department {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isAssignToTeamEnabled", "hasLogo", "isVisibleInCustomerPortal", "isDefault", "isEnabled");

    public Department() {
    }

    public Department(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Boolean getIsAssignToTeamEnabled() {
        return (Boolean)this.data.get("isAssignToTeamEnabled");
    }

    public void setIsAssignToTeamEnabled(Boolean isAssignToTeamEnabled) {
        this.data.put("isAssignToTeamEnabled", isAssignToTeamEnabled);
        this.update.add("isAssignToTeamEnabled");
    }

    public ChatStatus getChatStatus() {
        String responseValue = (String)this.data.get("chatStatus");
        ChatStatus value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "AVAILABLE": {
                value = ChatStatus.AVAILABLE;
                break;
            }
            case "DISABLED": {
                value = ChatStatus.DISABLED;
                break;
            }
            case "NOT_CREATED": {
                value = ChatStatus.NOT_CREATED;
            }
        }
        return value;
    }

    public Boolean getHasLogo() {
        return (Boolean)this.data.get("hasLogo");
    }

    public Boolean getIsVisibleInCustomerPortal() {
        return (Boolean)this.data.get("isVisibleInCustomerPortal");
    }

    public void setIsVisibleInCustomerPortal(Boolean isVisibleInCustomerPortal) {
        this.data.put("isVisibleInCustomerPortal", isVisibleInCustomerPortal);
        this.update.add("isVisibleInCustomerPortal");
    }

    public String getCreatorId() {
        return (String)this.data.get("creatorId");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public List<String> getAssociatedAgentIds() {
        return (List)this.data.get("associatedAgentIds");
    }

    public void setAssociatedAgentIds(List<String> associatedAgentIds) {
        this.data.put("associatedAgentIds", associatedAgentIds);
        this.update.add("associatedAgentIds");
    }

    public Boolean getIsDefault() {
        return (Boolean)this.data.get("isDefault");
    }

    public Boolean getIsEnabled() {
        return (Boolean)this.data.get("isEnabled");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public void setName(String name) {
        this.data.put("name", name);
        this.update.add("name");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getNameInCustomerPortal() {
        return (String)this.data.get("nameInCustomerPortal");
    }

    public void setNameInCustomerPortal(String nameInCustomerPortal) {
        this.data.put("nameInCustomerPortal", nameInCustomerPortal);
        this.update.add("nameInCustomerPortal");
    }

    private void setFieldValues(JSONObject departmentData) throws JSONException {
        Iterator itr = departmentData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = departmentData.get(key);
            if (departmentData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, departmentData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum ChatStatus {
        AVAILABLE("AVAILABLE"),
        DISABLED("DISABLED"),
        NOT_CREATED("NOT_CREATED");

        private String value;

        private ChatStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

