/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.customView;

import com.zoho.desk.customView.CustomView;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomViewAPI {
    private String mailId;

    private CustomViewAPI(String mailId) {
        this.mailId = mailId;
    }

    public static CustomViewAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new CustomViewAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<CustomView> getViews(Module module, String departmentId) {
        StringBuilder requestURL = new StringBuilder("/api/v1/views");
        if (module != null) {
            String moduleStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(moduleStr).append("module=").append(module.getValue());
        }
        if (departmentId != null) {
            String departmentIdStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(departmentIdStr).append("departmentId=").append(departmentId);
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<CustomView> customViewData = new ArrayList<CustomView>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    CustomView customViewRef = new CustomView(dataArray.getJSONObject(i));
                    customViewData.add(customViewRef);
                }
            }
            ArrayList<CustomView> arrayList = customViewData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public static enum Module {
        TICKETS("tickets"),
        CALLS("calls"),
        ACTIVITIES("activities"),
        ACCOUNTS("accounts"),
        CONTRACTS("contracts"),
        TASKS("tasks"),
        CONTACTS("contacts"),
        EVENTS("events"),
        PRODUCTS("products");

        private String value;

        private Module(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

