/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.contact;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ZohoCRMContact {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public ZohoCRMContact() {
    }

    public ZohoCRMContact(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "new": {
                value = Type.NEW;
                break;
            }
            case "potentials": {
                value = Type.POTENTIALS;
                break;
            }
            case "customers": {
                value = Type.CUSTOMERS;
                break;
            }
            case "contacts": {
                value = Type.CONTACTS;
                break;
            }
            case "leads": {
                value = Type.LEADS;
            }
        }
        return value;
    }

    private void setFieldValues(JSONObject zohoCRMContactData) throws JSONException {
        Iterator itr = zohoCRMContactData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = zohoCRMContactData.get(key);
            if (zohoCRMContactData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, zohoCRMContactData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Type {
        NEW("new"),
        POTENTIALS("potentials"),
        CUSTOMERS("customers"),
        CONTACTS("contacts"),
        LEADS("leads");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

