/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.contact;

import com.zoho.desk.contact.Contact;
import com.zoho.desk.contact.GetContactsFilter;
import com.zoho.desk.contact.GetContactsUnderProductFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactAPI {
    private String mailId;

    private ContactAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ContactAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ContactAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Contact> getContactsUnderProduct(String productId, Integer from, Integer limit, APIConstants.Contact.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Contact.Include> includeSet, GetContactsUnderProductFilter filter) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/contacts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Contact.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Contact> contactData = new ArrayList<Contact>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Contact contactRef = new Contact(dataArray.getJSONObject(i));
                    contactData.add(contactRef);
                }
            }
            ArrayList<Contact> arrayList = contactData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean moveToTrash(List<String> contactIds) {
        if (contactIds == null) {
            throw new ZDeskException("contactIds is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("contactIds", contactIds);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/moveToTrash");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Contact getContact(String contactId, EnumSet<APIConstants.Contact.Include> includeSet) {
        Object value;
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Contact.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Contact(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Contact> getContacts(Integer from, Integer limit, APIConstants.Contact.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Contact.Include> includeSet, GetContactsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Contact.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Contact> contactData = new ArrayList<Contact>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Contact contactRef = new Contact(dataArray.getJSONObject(i));
                    contactData.add(contactRef);
                }
            }
            ArrayList<Contact> arrayList = contactData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Contact> getContactsByIds(List<String> ids) {
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/contactsByIds");
        if (ids != null) {
            String idsStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            StringBuilder builder = new StringBuilder("ids=");
            for (int i = 0; i < ids.size(); ++i) {
                builder.append(ids.get(i));
                if (i == ids.size() - 1) continue;
                builder.append(",");
            }
            requestURL.append(idsStr).append("ids=").append(builder.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Contact> contactData = new ArrayList<Contact>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Contact contactRef = new Contact(dataArray.getJSONObject(i));
                    contactData.add(contactRef);
                }
            }
            ArrayList<Contact> arrayList = contactData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Contact createContact(Contact contact) {
        if (contact.getLastName() == null) {
            throw new ZDeskException("lastName is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(contact.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Contact contact2 = new Contact(new JSONObject(responseData));
            return contact2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Contact updateContact(String contactId, Contact contact) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(contact.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Contact contact2 = new Contact(new JSONObject(responseData));
            return contact2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

