/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.contact;

import com.zoho.desk.account.Account;
import com.zoho.desk.agent.Agent;
import com.zoho.desk.contact.CustomerHappiness;
import com.zoho.desk.contact.ZohoCRMContact;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Contact {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isDeleted", "isTrashed", "isEndUser", "isFollowing", "isAnonymous", "isSpam");

    public Contact() {
    }

    public Contact(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getLastName() {
        return (String)this.data.get("lastName");
    }

    public void setLastName(String lastName) {
        this.data.put("lastName", lastName);
        this.update.add("lastName");
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getCountry() {
        return (String)this.data.get("country");
    }

    public void setCountry(String country) {
        this.data.put("country", country);
        this.update.add("country");
    }

    public String getSecondaryEmail() {
        return (String)this.data.get("secondaryEmail");
    }

    public void setSecondaryEmail(String secondaryEmail) {
        this.data.put("secondaryEmail", secondaryEmail);
        this.update.add("secondaryEmail");
    }

    public String getCity() {
        return (String)this.data.get("city");
    }

    public void setCity(String city) {
        this.data.put("city", city);
        this.update.add("city");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public void setOwnerId(String ownerId) {
        this.data.put("ownerId", ownerId);
        this.update.add("ownerId");
    }

    public String getType() {
        return (String)this.data.get("type");
    }

    public void setType(String type) {
        this.data.put("type", type);
        this.update.add("type");
    }

    public String getTitle() {
        return (String)this.data.get("title");
    }

    public void setTitle(String title) {
        this.data.put("title", title);
        this.update.add("title");
    }

    public String getPhotoURL() {
        return (String)this.data.get("photoURL");
    }

    public String getTwitter() {
        return (String)this.data.get("twitter");
    }

    public void setTwitter(String twitter) {
        this.data.put("twitter", twitter);
        this.update.add("twitter");
    }

    public Boolean getIsDeleted() {
        return (Boolean)this.data.get("isDeleted");
    }

    public Boolean getIsTrashed() {
        return (Boolean)this.data.get("isTrashed");
    }

    public String getStreet() {
        return (String)this.data.get("street");
    }

    public void setStreet(String street) {
        this.data.put("street", street);
        this.update.add("street");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Boolean getIsEndUser() {
        return (Boolean)this.data.get("isEndUser");
    }

    public ZohoCRMContact getZohoCRMContact() {
        try {
            Map value = (Map)this.data.get("zohoCRMContact");
            if (value == null) {
                return null;
            }
            return new ZohoCRMContact(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public CustomerHappiness getCustomerHappiness() {
        try {
            Map value = (Map)this.data.get("customerHappiness");
            if (value == null) {
                return null;
            }
            return new CustomerHappiness(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getState() {
        return (String)this.data.get("state");
    }

    public void setState(String state) {
        this.data.put("state", state);
        this.update.add("state");
    }

    public String getEmail() {
        return (String)this.data.get("email");
    }

    public void setEmail(String email) {
        this.data.put("email", email);
        this.update.add("email");
    }

    public String getZip() {
        return (String)this.data.get("zip");
    }

    public void setZip(String zip) {
        this.data.put("zip", zip);
        this.update.add("zip");
    }

    public Long getCfFieldAsLong(String label) {
        try {
            return this.getCf(label) != null ? Long.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Double getCfFieldAsDouble(String label) {
        try {
            return this.getCf(label) != null ? Double.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Integer getCfFieldAsInteger(String label) {
        try {
            return this.getCf(label) != null ? Integer.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Boolean getCfFieldAsBoolean(String label) {
        return this.getCf(label) != null ? Boolean.valueOf(this.getCf(label)) : null;
    }

    public List<String> getCfFieldAsList(String label) {
        return this.getCf(label) != null ? Arrays.asList(this.getCf(label).split(";")) : null;
    }

    public String getCf(String label) {
        Map cf;
        if (this.data.containsKey("cf") && (cf = (Map)this.data.get("cf")).containsKey(label)) {
            if (cf.get(label) != null) {
                return (String)cf.get(label);
            }
            return null;
        }
        return null;
    }

    public void setCf(String key, String value) {
        HashMap<String, String> cf = (HashMap<String, String>)this.data.get("cf");
        if (cf == null) {
            cf = new HashMap<String, String>();
        }
        cf.put(key, value);
        this.data.put("cf", cf);
        this.update.add("cf");
    }

    public Boolean getIsFollowing() {
        return (Boolean)this.data.get("isFollowing");
    }

    public String getFacebook() {
        return (String)this.data.get("facebook");
    }

    public void setFacebook(String facebook) {
        this.data.put("facebook", facebook);
        this.update.add("facebook");
    }

    public String getMobile() {
        return (String)this.data.get("mobile");
    }

    public void setMobile(String mobile) {
        this.data.put("mobile", mobile);
        this.update.add("mobile");
    }

    public String getAccountId() {
        return (String)this.data.get("accountId");
    }

    public void setAccountId(String accountId) {
        this.data.put("accountId", accountId);
        this.update.add("accountId");
    }

    public String getFirstName() {
        return (String)this.data.get("firstName");
    }

    public void setFirstName(String firstName) {
        this.data.put("firstName", firstName);
        this.update.add("firstName");
    }

    public Boolean getIsAnonymous() {
        return (Boolean)this.data.get("isAnonymous");
    }

    public String getPhone() {
        return (String)this.data.get("phone");
    }

    public void setPhone(String phone) {
        this.data.put("phone", phone);
        this.update.add("phone");
    }

    public String getWebUrl() {
        return (String)this.data.get("webUrl");
    }

    public Boolean getIsSpam() {
        return (Boolean)this.data.get("isSpam");
    }

    public Agent getOwner() {
        return (Agent)this.data.get("owner");
    }

    public Account getAccount() {
        return (Account)this.data.get("account");
    }

    private void setFieldValues(JSONObject contactData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(contactData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = contactData.get(key);
            if (contactData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, contactData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject contactData) throws JSONException {
        if (contactData.has("owner")) {
            if (contactData.isNull("owner")) {
                this.data.put("owner", null);
                contactData.remove("owner");
            } else {
                Agent owner = new Agent(contactData.getJSONObject("owner"));
                this.data.put("owner", owner);
                contactData.remove("owner");
            }
        }
        if (contactData.has("account")) {
            if (contactData.isNull("account")) {
                this.data.put("account", null);
                contactData.remove("account");
            } else {
                Account account = new Account(contactData.getJSONObject("account"));
                this.data.put("account", account);
                contactData.remove("account");
            }
        }
        return contactData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

