/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.comment;

import com.zoho.desk.comment.Agent;
import com.zoho.desk.comment.Ticket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Mention {
    private Map<String, Object> data = new HashMap<String, Object>();
    private List<String> mentionFields = Arrays.asList("offSet", "length", "id", "type");

    public Mention(JSONObject mentionData) throws JSONException {
        JSONObject moduleContent = new JSONObject();
        Iterator itr = mentionData.keys();
        while (itr.hasNext()) {
            String value;
            String key = (String)itr.next();
            String string = value = mentionData.isNull(key) ? null : mentionData.getString(key);
            if (this.mentionFields.contains(key)) {
                this.data.put(key, value);
                continue;
            }
            moduleContent.put(key, (Object)value);
        }
        if (mentionData.getString("type").equals("AGENT")) {
            this.data.put("agent", new Agent(moduleContent));
        } else if (mentionData.getString("type").equals("TEAM")) {
            String teamName = moduleContent.isNull("name") ? null : moduleContent.get("name").toString();
            this.data.put("team", teamName);
        } else if (mentionData.getString("type").equals("TICKET")) {
            this.data.put("ticket", new Ticket(moduleContent));
        }
    }

    public String getOffset() {
        return (String)this.data.get("offset");
    }

    public String getLength() {
        return (String)this.data.get("length");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getType() {
        return (String)this.data.get("type");
    }

    public Agent getAgent() {
        return (Agent)this.data.get("agent");
    }

    public String getTeamName() {
        return (String)this.data.get("team");
    }

    public Ticket getTicket() {
        return (Ticket)this.data.get("ticket");
    }

    public String toString() {
        return this.data.toString();
    }
}

