/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.comment;

import com.zoho.desk.init.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Commenter {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList(new String[0]);

    public Commenter() {
    }

    public Commenter(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getPhotoURL() {
        return (String)this.data.get("photoURL");
    }

    public String getFirstName() {
        return (String)this.data.get("firstName");
    }

    public String getLastName() {
        return (String)this.data.get("lastName");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public String getRoleName() {
        return (String)this.data.get("roleName");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "END_USER": {
                value = Type.END_USER;
                break;
            }
            case "AGENT": {
                value = Type.AGENT;
                break;
            }
            case "TEAM": {
                value = Type.TEAM;
                break;
            }
            case "TICKET": {
                value = Type.TICKET;
                break;
            }
            case "ACTIVITY": {
                value = Type.ACTIVITY;
            }
        }
        return value;
    }

    public String getEmail() {
        return (String)this.data.get("email");
    }

    private void setFieldValues(JSONObject commenterData) throws JSONException {
        Iterator itr = commenterData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = commenterData.get(key);
            if (commenterData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, commenterData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Type {
        END_USER("END_USER"),
        AGENT("AGENT"),
        TEAM("TEAM"),
        TICKET("TICKET"),
        ACTIVITY("ACTIVITY");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

