/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.comment;

import com.zoho.desk.comment.Comment;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommentAPI {
    private String mailId;

    private CommentAPI(String mailId) {
        this.mailId = mailId;
    }

    public static CommentAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new CommentAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public boolean deleteAccountComment(String accountId, String commentId) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/comments/" + commentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Comment> getAccountComments(String accountId, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getAccountComment(String accountId, String commentId, EnumSet<APIConstants.Comment.Include> includeSet) {
        Object value;
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/comments/" + commentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Comment(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateAccountComment(String accountId, String commentId, Comment comment) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/comments/" + commentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createAccountComment(String accountId, Comment comment) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/comments");
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment deleteArticleComment(String articleId, String commentId, String locale) {
        if (articleId == null) {
            throw new ZDeskException("articleId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (locale == null) {
            throw new ZDeskException("locale is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/articles/" + articleId + "/translations/" + locale + "/comments/" + commentId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment = new Comment(new JSONObject(responseData));
            return comment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Comment> getArticleComments(String articleId, String locale, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending) {
        if (articleId == null) {
            throw new ZDeskException("articleId is mandatory PathParam");
        }
        if (locale == null) {
            throw new ZDeskException("locale is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/articles/" + articleId + "/translations/" + locale + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getArticleComment(String articleId, String commentId, String locale) {
        if (articleId == null) {
            throw new ZDeskException("articleId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (locale == null) {
            throw new ZDeskException("locale is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/articles/" + articleId + "/translations/" + locale + "/comments/" + commentId);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment = new Comment(new JSONObject(responseData));
            return comment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateArticleComment(String articleId, String commentId, String locale, Comment comment) {
        if (articleId == null) {
            throw new ZDeskException("articleId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (locale == null) {
            throw new ZDeskException("locale is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/articles/" + articleId + "/translations/" + locale + "/comments/" + commentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createArticleComment(String articleId, String locale, Comment comment) {
        if (articleId == null) {
            throw new ZDeskException("articleId is mandatory PathParam");
        }
        if (locale == null) {
            throw new ZDeskException("locale is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/articles/" + articleId + "/translations/" + locale + "/comments");
        if (comment.getIsPublic() == null) {
            throw new ZDeskException("isPublic is mandatory payload key");
        }
        if (comment.getContentType() == null) {
            throw new ZDeskException("contentType is mandatory payload key");
        }
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteCallComment(String callId, String commentId) {
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId + "/comments/" + commentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Comment> getCallComments(String callId, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getCallComment(String callId, String commentId, EnumSet<APIConstants.Comment.Include> includeSet) {
        Object value;
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId + "/comments/" + commentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Comment(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateCallComment(String callId, String commentId, Comment comment) {
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId + "/comments/" + commentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createCallComment(String callId, Comment comment) {
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId + "/comments");
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteContactComment(String contactId, String commentId) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/comments/" + commentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Comment> getContactComments(String contactId, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getContactComment(String contactId, String commentId, EnumSet<APIConstants.Comment.Include> includeSet) {
        Object value;
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/comments/" + commentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Comment(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateContactComment(String contactId, String commentId, Comment comment) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/comments/" + commentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createContactComment(String contactId, Comment comment) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/comments");
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteTicketComment(String commentId, String ticketId) {
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments/" + commentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Comment> getTicketComments(String ticketId, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Comment> getTicketCommentHistory(String commentId, String ticketId, Integer from, Integer limit, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments/" + commentId + "/history");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getTicketComment(String commentId, String ticketId, EnumSet<APIConstants.Comment.Include> includeSet) {
        Object value;
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments/" + commentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Comment(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateTicketComment(String commentId, String ticketId, Comment comment) {
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments/" + commentId);
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createTicketComment(String ticketId, Comment comment) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/comments");
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteEventComment(String eventId, String commentId) {
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId + "/comments/" + commentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Comment> getEventComments(String eventId, Integer from, Integer limit, APIConstants.Comment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Comment.Include> includeSet) {
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId + "/comments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Comment> commentData = new ArrayList<Comment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Comment commentRef = new Comment(dataArray.getJSONObject(i));
                    commentData.add(commentRef);
                }
            }
            ArrayList<Comment> arrayList = commentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment getEventComment(String eventId, String commentId, EnumSet<APIConstants.Comment.Include> includeSet) {
        Object value;
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId + "/comments/" + commentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Comment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Comment(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment updateEventComment(String eventId, String commentId, Comment comment) {
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        if (commentId == null) {
            throw new ZDeskException("commentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId + "/comments/" + commentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Comment createEventComment(String eventId, Comment comment) {
        if (eventId == null) {
            throw new ZDeskException("eventId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/events/" + eventId + "/comments");
        if (comment.getContent() == null) {
            throw new ZDeskException("content is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(comment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Comment comment2 = new Comment(new JSONObject(responseData));
            return comment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

