/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.comment;

import com.zoho.desk.attachment.Attachment;
import com.zoho.desk.comment.Commenter;
import com.zoho.desk.comment.Mention;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Comment {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isPublic");

    public Comment() {
    }

    public Comment(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Attachment> getAttachments() {
        try {
            ArrayList<Attachment> result = new ArrayList<Attachment>();
            List value = (List)this.data.get("attachments");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Attachment(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getEncodedContent() {
        return (String)this.data.get("encodedContent");
    }

    public Date getCommentedTime() throws ZDeskException {
        try {
            String commentedTimeValue = (String)this.data.get("commentedTime");
            return commentedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(commentedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Boolean getIsPublic() {
        return (Boolean)this.data.get("isPublic");
    }

    public void setIsPublic(Boolean isPublic) {
        this.data.put("isPublic", isPublic);
        this.update.add("isPublic");
    }

    public List<String> getAttachmentIds() {
        return (List)this.data.get("attachmentIds");
    }

    public void setAttachmentIds(List<String> attachmentIds) {
        this.data.put("attachmentIds", attachmentIds);
        this.update.add("attachmentIds");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public ContentType getContentType() {
        String responseValue = (String)this.data.get("contentType");
        ContentType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "plainText": {
                value = ContentType.PLAINTEXT;
                break;
            }
            case "html": {
                value = ContentType.HTML;
            }
        }
        return value;
    }

    public void setContentType(ContentType contentType) {
        String value = null;
        if (contentType != null) {
            value = contentType.getValue();
        }
        this.data.put("contentType", value);
        this.update.add("contentType");
    }

    public String getCommenterId() {
        return (String)this.data.get("commenterId");
    }

    public String getContent() {
        return (String)this.data.get("content");
    }

    public void setContent(String content) {
        this.data.put("content", content);
        this.update.add("content");
    }

    public Commenter getCommenter() {
        try {
            Map value = (Map)this.data.get("commenter");
            if (value == null) {
                return null;
            }
            return new Commenter(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public List<Mention> getMentions() {
        return (List)this.data.get("mention");
    }

    private void setFieldValues(JSONObject commentData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(commentData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = commentData.get(key);
            if (commentData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, commentData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject commentData) throws JSONException {
        if (commentData.has("mention")) {
            if (commentData.isNull("mention")) {
                this.data.put("mention", null);
                commentData.remove("mention");
            } else {
                ArrayList<Mention> mentions = new ArrayList<Mention>();
                JSONArray mentionData = commentData.getJSONArray("mention");
                for (int i = 0; i < mentionData.length(); ++i) {
                    mentions.add(new Mention(mentionData.getJSONObject(i)));
                }
                this.data.put("mention", mentions);
                commentData.remove("mention");
            }
        }
        return commentData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum ContentType {
        PLAINTEXT("plainText"),
        HTML("html");

        private String value;

        private ContentType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

