/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.channel;

import com.zoho.desk.init.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReplyConfig {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("updateRecords", "acceptsAttachments", "includeQuotedMessage");

    public ReplyConfig() {
    }

    public ReplyConfig(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Boolean getUpdateRecords() {
        return (Boolean)this.data.get("updateRecords");
    }

    public Boolean getAcceptsAttachments() {
        return (Boolean)this.data.get("acceptsAttachments");
    }

    public List<ContentTypes> getContentTypes() {
        ArrayList<ContentTypes> result = new ArrayList<ContentTypes>();
        List value = (List)this.data.get("contentTypes");
        if (value == null) {
            return null;
        }
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            String responseValue;
            switch (responseValue = (String)iterator.next()) {
                case "text/plain": {
                    result.add(ContentTypes.TEXT_PLAIN);
                    break;
                }
                case "text/html": {
                    result.add(ContentTypes.TEXT_HTML);
                }
            }
        }
        return result;
    }

    public Boolean getIncludeQuotedMessage() {
        return (Boolean)this.data.get("includeQuotedMessage");
    }

    private void setFieldValues(JSONObject replyConfigData) throws JSONException {
        Iterator itr = replyConfigData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = replyConfigData.get(key);
            if (replyConfigData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, replyConfigData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum ContentTypes {
        TEXT_PLAIN("text/plain"),
        TEXT_HTML("text/html");

        private String value;

        private ContentTypes(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

