/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.channel;

import com.zoho.desk.channel.Channel;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelAPI {
    private String mailId;

    private ChannelAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ChannelAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ChannelAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public Channel getChannelByCode(String channelCode) {
        if (channelCode == null) {
            throw new ZDeskException("channelCode is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/channels/" + channelCode);
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Channel channel = new Channel(new JSONObject(responseData));
            return channel;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Channel> getChannels() {
        StringBuilder requestURL = new StringBuilder("/api/v1/channels");
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Channel> channelData = new ArrayList<Channel>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Channel channelRef = new Channel(dataArray.getJSONObject(i));
                    channelData.add(channelRef);
                }
            }
            ArrayList<Channel> arrayList = channelData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

