/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.channel;

import com.zoho.desk.channel.ReplyConfig;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Channel {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("acceptsReplies");

    public Channel() {
    }

    public Channel(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getPhotoURL() {
        return (String)this.data.get("photoURL");
    }

    public String getCode() {
        return (String)this.data.get("code");
    }

    public String getAppName() {
        return (String)this.data.get("appName");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public String getExternalId() {
        return (String)this.data.get("externalId");
    }

    public ReplyConfig getReplyConfig() {
        try {
            Map value = (Map)this.data.get("replyConfig");
            if (value == null) {
                return null;
            }
            return new ReplyConfig(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public Type getType() {
        String responseValue = (String)this.data.get("type");
        Type value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "SYSTEM": {
                value = Type.SYSTEM;
                break;
            }
            case "INTEGRATION": {
                value = Type.INTEGRATION;
            }
        }
        return value;
    }

    public Boolean getAcceptsReplies() {
        return (Boolean)this.data.get("acceptsReplies");
    }

    private void setFieldValues(JSONObject channelData) throws JSONException {
        Iterator itr = channelData.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = channelData.get(key);
            if (channelData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, channelData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Type {
        SYSTEM("SYSTEM"),
        INTEGRATION("INTEGRATION");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

