/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.call;

import com.zoho.desk.init.Filter;

public class GetCallsFilter
extends Filter {
    private GetCallsFilter() {
    }

    public static class Builder {
        GetCallsFilter filter = new GetCallsFilter();

        public Builder setViewId(String viewId) {
            this.filter.setQueryParam("viewId", viewId);
            return this;
        }

        public Builder setDepartmentId(String departmentId) {
            this.filter.setQueryParam("departmentId", departmentId);
            return this;
        }

        public Builder setStartTime(StartTime startTime) {
            this.filter.setQueryParam("startTime", startTime.getValue());
            return this;
        }

        public Builder setDepartmentIds(String departmentIds) {
            this.filter.setQueryParam("departmentIds", departmentIds);
            return this;
        }

        public Builder setAssignee(String assignee) {
            this.filter.setQueryParam("assignee", assignee);
            return this;
        }

        public Builder setIsCompleted(Boolean isCompleted) {
            this.filter.setQueryParam("isCompleted", isCompleted);
            return this;
        }

        public GetCallsFilter build() {
            return this.filter;
        }
    }

    public static enum StartTime {
        OVERDUE("Overdue"),
        TOMORROW("Tomorrow"),
        CURRENTWEEK("CurrentWeek"),
        CURRENTMONTH("CurrentMonth"),
        TODAY("Today");

        private String value;

        private StartTime(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

