/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.call;

import com.zoho.desk.call.Call;
import com.zoho.desk.call.GetCallsByTicketFilter;
import com.zoho.desk.call.GetCallsFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CallAPI {
    private String mailId;

    private CallAPI(String mailId) {
        this.mailId = mailId;
    }

    public static CallAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new CallAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Call> getCalls(Integer from, Integer limit, APIConstants.Call.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Call.Include> includeSet, GetCallsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/calls");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Call.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Call> callData = new ArrayList<Call>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Call callRef = new Call(dataArray.getJSONObject(i));
                    callData.add(callRef);
                }
            }
            ArrayList<Call> arrayList = callData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Call updateCall(String callId, Call call) {
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(call.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Call call2 = new Call(new JSONObject(responseData));
            return call2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean moveToTrash(List<String> entityIds) {
        if (entityIds == null) {
            throw new ZDeskException("entityIds is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("entityIds", entityIds);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/moveToTrash");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Call getCall(String callId, EnumSet<APIConstants.Call.Include> includeSet) {
        Object value;
        if (callId == null) {
            throw new ZDeskException("callId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls/" + callId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Call.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Call(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Call> getCallsByTicket(String ticketId, Integer from, Integer limit, APIConstants.Call.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Call.Include> includeSet, GetCallsByTicketFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/calls");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Call.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Call> callData = new ArrayList<Call>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Call callRef = new Call(dataArray.getJSONObject(i));
                    callData.add(callRef);
                }
            }
            ArrayList<Call> arrayList = callData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Call createCall(Call call) {
        if (call.getContactId() == null) {
            throw new ZDeskException("contactId is mandatory payload key");
        }
        if (call.getSubject() == null) {
            throw new ZDeskException("subject is mandatory payload key");
        }
        if (call.getDepartmentId() == null) {
            throw new ZDeskException("departmentId is mandatory payload key");
        }
        if (call.getDuration() == null) {
            throw new ZDeskException("duration is mandatory payload key");
        }
        if (call.getStartTime() == null) {
            throw new ZDeskException("startTime is mandatory payload key");
        }
        if (call.getDirection() == null) {
            throw new ZDeskException("direction is mandatory payload key");
        }
        if (call.getStatus() == null) {
            throw new ZDeskException("status is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/calls");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(call.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Call call2 = new Call(new JSONObject(responseData));
            return call2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

