/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.call;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.call.Livecall;
import com.zoho.desk.call.ModifiedBy;
import com.zoho.desk.call.Reminder;
import com.zoho.desk.contact.Contact;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.team.Team;
import com.zoho.desk.ticket.Ticket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Call {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isCommented");

    public Call() {
    }

    public Call(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Long getCfFieldAsLong(String label) {
        try {
            return this.getCf(label) != null ? Long.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Double getCfFieldAsDouble(String label) {
        try {
            return this.getCf(label) != null ? Double.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Integer getCfFieldAsInteger(String label) {
        try {
            return this.getCf(label) != null ? Integer.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Boolean getCfFieldAsBoolean(String label) {
        return this.getCf(label) != null ? Boolean.valueOf(this.getCf(label)) : null;
    }

    public List<String> getCfFieldAsList(String label) {
        return this.getCf(label) != null ? Arrays.asList(this.getCf(label).split(";")) : null;
    }

    public String getCf(String label) {
        Map cf;
        if (this.data.containsKey("cf") && (cf = (Map)this.data.get("cf")).containsKey(label)) {
            if (cf.get(label) != null) {
                return (String)cf.get(label);
            }
            return null;
        }
        return null;
    }

    public void setCf(String key, String value) {
        HashMap<String, String> cf = (HashMap<String, String>)this.data.get("cf");
        if (cf == null) {
            cf = new HashMap<String, String>();
        }
        cf.put(key, value);
        this.data.put("cf", cf);
        this.update.add("cf");
    }

    public List<Reminder> getReminder() {
        try {
            ArrayList<Reminder> result = new ArrayList<Reminder>();
            List value = (List)this.data.get("reminder");
            if (value == null) {
                return null;
            }
            for (Map subProps : value) {
                result.add(new Reminder(new JSONObject(subProps)));
            }
            return result;
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public void setReminder(List<Reminder> reminder) {
        this.data.put("reminder", reminder);
        this.update.add("reminder");
    }

    public String getContactId() {
        return (String)this.data.get("contactId");
    }

    public void setContactId(String contactId) {
        this.data.put("contactId", contactId);
        this.update.add("contactId");
    }

    public Date getCompletedTime() throws ZDeskException {
        try {
            String completedTimeValue = (String)this.data.get("completedTime");
            return completedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(completedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getSubject() {
        return (String)this.data.get("subject");
    }

    public void setSubject(String subject) {
        this.data.put("subject", subject);
        this.update.add("subject");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public void setDepartmentId(String departmentId) {
        this.data.put("departmentId", departmentId);
        this.update.add("departmentId");
    }

    public String getCreatorId() {
        return (String)this.data.get("creatorId");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public void setOwnerId(String ownerId) {
        this.data.put("ownerId", ownerId);
        this.update.add("ownerId");
    }

    public String getPriority() {
        return (String)this.data.get("priority");
    }

    public void setPriority(String priority) {
        this.data.put("priority", priority);
        this.update.add("priority");
    }

    public String getDuration() {
        return (String)this.data.get("duration");
    }

    public void setDuration(String duration) {
        this.data.put("duration", duration);
        this.update.add("duration");
    }

    public Boolean getIsCommented() {
        return (Boolean)this.data.get("isCommented");
    }

    public String getWebUrl() {
        return (String)this.data.get("webUrl");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public ModifiedBy getModifiedBy() {
        try {
            Map value = (Map)this.data.get("modifiedBy");
            if (value == null) {
                return null;
            }
            return new ModifiedBy(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public Date getStartTime() throws ZDeskException {
        try {
            String startTimeValue = (String)this.data.get("startTime");
            return startTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(startTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public void setStartTime(Date startTime) {
        String time = null;
        if (startTime != null) {
            time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(startTime);
        }
        this.data.put("startTime", time);
        this.update.add("startTime");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public String getTicketId() {
        return (String)this.data.get("ticketId");
    }

    public void setTicketId(String ticketId) {
        this.data.put("ticketId", ticketId);
        this.update.add("ticketId");
    }

    public Direction getDirection() {
        String responseValue = (String)this.data.get("direction");
        Direction value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "inbound": {
                value = Direction.INBOUND;
                break;
            }
            case "outbound": {
                value = Direction.OUTBOUND;
            }
        }
        return value;
    }

    public void setDirection(Direction direction) {
        String value = null;
        if (direction != null) {
            value = direction.getValue();
        }
        this.data.put("direction", value);
        this.update.add("direction");
    }

    public Status getStatus() {
        String responseValue = (String)this.data.get("status");
        Status value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Scheduled": {
                value = Status.SCHEDULED;
                break;
            }
            case "Completed": {
                value = Status.COMPLETED;
                break;
            }
            case "Missed": {
                value = Status.MISSED;
                break;
            }
            case "In Progress": {
                value = Status.INPROGRESS;
                break;
            }
            case "Canceled": {
                value = Status.CANCELED;
            }
        }
        return value;
    }

    public void setStatus(Status status) {
        String value = null;
        if (status != null) {
            value = status.getValue();
        }
        this.data.put("status", value);
        this.update.add("status");
    }

    public Ticket getTicket() {
        return (Ticket)this.data.get("ticket");
    }

    public Contact getContact() {
        return (Contact)this.data.get("contact");
    }

    public Agent getAssignee() {
        return (Agent)this.data.get("assignee");
    }

    public Team getTeam() {
        return (Team)this.data.get("team");
    }

    public List<Livecall> getLivecall() {
        return (List)this.data.get("livecall");
    }

    private void setFieldValues(JSONObject callData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(callData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = callData.get(key);
            if (callData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, callData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject callData) throws JSONException {
        if (callData.has("ticket")) {
            if (callData.isNull("ticket")) {
                this.data.put("ticket", null);
                callData.remove("ticket");
            } else {
                Ticket ticket = new Ticket(callData.getJSONObject("ticket"));
                this.data.put("ticket", ticket);
                callData.remove("ticket");
            }
        }
        if (callData.has("contact")) {
            if (callData.isNull("contact")) {
                this.data.put("contact", null);
                callData.remove("contact");
            } else {
                Contact contact = new Contact(callData.getJSONObject("contact"));
                this.data.put("contact", contact);
                callData.remove("contact");
            }
        }
        if (callData.has("assignee")) {
            if (callData.isNull("assignee")) {
                this.data.put("assignee", null);
                callData.remove("assignee");
            } else {
                Agent assignee = new Agent(callData.getJSONObject("assignee"));
                this.data.put("assignee", assignee);
                callData.remove("assignee");
            }
        }
        if (callData.has("team")) {
            if (callData.isNull("team")) {
                this.data.put("team", null);
                callData.remove("team");
            } else {
                Team team = new Team(callData.getJSONObject("team"));
                this.data.put("team", team);
                callData.remove("team");
            }
        }
        if (callData.has("livecall")) {
            if (callData.isNull("livecall")) {
                this.data.put("livecall", null);
                callData.remove("livecall");
            } else {
                ArrayList<Livecall> livecall = new ArrayList<Livecall>();
                JSONArray livecallData = callData.getJSONArray("livecall");
                for (int i = 0; i < livecallData.length(); ++i) {
                    livecall.add(new Livecall(livecallData.getJSONObject(i)));
                }
                this.data.put("livecall", livecall);
                callData.remove("livecall");
            }
        }
        return callData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Status {
        SCHEDULED("Scheduled"),
        COMPLETED("Completed"),
        MISSED("Missed"),
        INPROGRESS("In Progress"),
        CANCELED("Canceled");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

