/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.attachment;

import com.zoho.desk.attachment.Attachment;
import com.zoho.desk.attachment.CreateTicketAttachmentFilter;
import com.zoho.desk.attachment.GetTicketAttachmentsFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttachmentAPI {
    private String mailId;

    private AttachmentAPI(String mailId) {
        this.mailId = mailId;
    }

    public static AttachmentAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new AttachmentAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Attachment> getTicketAttachments(String ticketId, Integer from, Integer limit, APIConstants.Attachment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Attachment.Include> includeSet, GetTicketAttachmentsFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/attachments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Attachment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Attachment> attachmentData = new ArrayList<Attachment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Attachment attachmentRef = new Attachment(dataArray.getJSONObject(i));
                    attachmentData.add(attachmentRef);
                }
            }
            ArrayList<Attachment> arrayList = attachmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Attachment createTicketAttachment(File file, String ticketId, CreateTicketAttachmentFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/attachments");
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment = new Attachment(new JSONObject(responseData));
            return attachment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteTicketAttachment(String attachmentId, String ticketId) {
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/attachments/" + attachmentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Attachment updateTicketAttachment(String attachmentId, String ticketId, Attachment attachment) {
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/attachments/" + attachmentId);
        if (attachment.getIsPublic() == null) {
            throw new ZDeskException("isPublic is mandatory payload key");
        }
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(attachment.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment2 = new Attachment(new JSONObject(responseData));
            return attachment2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Attachment> getProductAttachments(String productId, Integer from, Integer limit, APIConstants.Attachment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Attachment.Include> includeSet) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/attachments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Attachment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Attachment> attachmentData = new ArrayList<Attachment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Attachment attachmentRef = new Attachment(dataArray.getJSONObject(i));
                    attachmentData.add(attachmentRef);
                }
            }
            ArrayList<Attachment> arrayList = attachmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Attachment createProductAttachment(File file, String productId) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/attachments");
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment = new Attachment(new JSONObject(responseData));
            return attachment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteProductAttachment(String productId, String attachmentId) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/attachments/" + attachmentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Attachment> getTaskAttachments(String taskId, Integer from, Integer limit, APIConstants.Attachment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Attachment.Include> includeSet) {
        if (taskId == null) {
            throw new ZDeskException("taskId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks/" + taskId + "/attachments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Attachment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Attachment> attachmentData = new ArrayList<Attachment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Attachment attachmentRef = new Attachment(dataArray.getJSONObject(i));
                    attachmentData.add(attachmentRef);
                }
            }
            ArrayList<Attachment> arrayList = attachmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Attachment createTaskAttachment(File file, String taskId) {
        if (taskId == null) {
            throw new ZDeskException("taskId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks/" + taskId + "/attachments");
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment = new Attachment(new JSONObject(responseData));
            return attachment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteTaskAttachment(String attachmentId, String taskId) {
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        if (taskId == null) {
            throw new ZDeskException("taskId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tasks/" + taskId + "/attachments/" + attachmentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Attachment> getContactAttachments(String contactId, Integer from, Integer limit, APIConstants.Attachment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Attachment.Include> includeSet) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/attachments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Attachment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Attachment> attachmentData = new ArrayList<Attachment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Attachment attachmentRef = new Attachment(dataArray.getJSONObject(i));
                    attachmentData.add(attachmentRef);
                }
            }
            ArrayList<Attachment> arrayList = attachmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Attachment createContactAttachment(File file, String contactId) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/attachments");
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment = new Attachment(new JSONObject(responseData));
            return attachment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteContactAttachment(String contactId, String attachmentId) {
        if (contactId == null) {
            throw new ZDeskException("contactId is mandatory PathParam");
        }
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/contacts/" + contactId + "/attachments/" + attachmentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Attachment> getAccountAttachments(String accountId, Integer from, Integer limit, APIConstants.Attachment.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Attachment.Include> includeSet) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/attachments");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Attachment.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Attachment> attachmentData = new ArrayList<Attachment>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Attachment attachmentRef = new Attachment(dataArray.getJSONObject(i));
                    attachmentData.add(attachmentRef);
                }
            }
            ArrayList<Attachment> arrayList = attachmentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Attachment createAccountAttachment(File file, String accountId) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/attachments");
        if (file == null) {
            throw new ZDeskException("file is mandatory payload data");
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("file", file);
        HttpEntity payloadEntity = entityBuilder.build();
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), payloadEntity, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Attachment attachment = new Attachment(new JSONObject(responseData));
            return attachment;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public boolean deleteAccountAttachment(String accountId, String attachmentId) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        if (attachmentId == null) {
            throw new ZDeskException("attachmentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/attachments/" + attachmentId);
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.DELETE, requestURL.toString(), null, this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }
}

