/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.agent;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.agent.GetAgentsFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgentAPI {
    private String mailId;

    private AgentAPI(String mailId) {
        this.mailId = mailId;
    }

    public static AgentAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new AgentAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public boolean updateMyPreferences(List<String> namePattern, String currentDepartment) {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (namePattern != null) {
            inputData.put("namePattern", namePattern);
        }
        if (currentDepartment != null) {
            inputData.put("currentDepartment", currentDepartment);
        }
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/myPreferences");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Agent> getAgentsByIds(List<String> agentIds) {
        StringBuilder requestURL = new StringBuilder("/api/v1/agentsByIds");
        if (agentIds != null) {
            String agentIdsStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            StringBuilder builder = new StringBuilder("agentIds=");
            for (int i = 0; i < agentIds.size(); ++i) {
                builder.append(agentIds.get(i));
                if (i == agentIds.size() - 1) continue;
                builder.append(",");
            }
            requestURL.append(agentIdsStr).append("agentIds=").append(builder.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Agent> agentData = new ArrayList<Agent>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Agent agentRef = new Agent(dataArray.getJSONObject(i));
                    agentData.add(agentRef);
                }
            }
            ArrayList<Agent> arrayList = agentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Agent getAgent(String agentId, EnumSet<APIConstants.Agent.Include> includeSet) {
        Object value;
        if (agentId == null) {
            throw new ZDeskException("agentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/agents/" + agentId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Agent.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Agent(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Agent addAgent(Agent agent) {
        if (agent.getLastName() == null) {
            throw new ZDeskException("lastName is mandatory payload key");
        }
        if (agent.getEmailId() == null) {
            throw new ZDeskException("emailId is mandatory payload key");
        }
        if (agent.getAssociatedDepartmentIds() == null) {
            throw new ZDeskException("associatedDepartmentIds is mandatory payload key");
        }
        if (agent.getRolePermissionType() == null) {
            throw new ZDeskException("rolePermissionType is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/agents");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(agent.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Agent agent2 = new Agent(new JSONObject(responseData));
            return agent2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Agent getMyInfo(EnumSet<APIConstants.Agent.Include> includeSet) {
        Object value;
        StringBuilder requestURL = new StringBuilder("/api/v1/myinfo");
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Agent.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Agent(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Agent updateAgent(String agentId, Agent agent) {
        if (agentId == null) {
            throw new ZDeskException("agentId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/agents/" + agentId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(agent.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Agent agent2 = new Agent(new JSONObject(responseData));
            return agent2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Agent> getAgents(Integer from, Integer limit, EnumSet<APIConstants.Agent.Include> includeSet, GetAgentsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/agents");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Agent.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Agent> agentData = new ArrayList<Agent>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Agent agentRef = new Agent(dataArray.getJSONObject(i));
                    agentData.add(agentRef);
                }
            }
            ArrayList<Agent> arrayList = agentData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

