/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.agent;

import com.zoho.desk.department.Department;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.profile.Profile;
import com.zoho.desk.role.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Agent {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isConfirmed");

    public Agent() {
    }

    public Agent(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getLastName() {
        return (String)this.data.get("lastName");
    }

    public void setLastName(String lastName) {
        this.data.put("lastName", lastName);
        this.update.add("lastName");
    }

    public String getExtn() {
        return (String)this.data.get("extn");
    }

    public void setExtn(String extn) {
        this.data.put("extn", extn);
        this.update.add("extn");
    }

    public String getRoleId() {
        return (String)this.data.get("roleId");
    }

    public String getLangCode() {
        return (String)this.data.get("langCode");
    }

    public void setLangCode(String langCode) {
        this.data.put("langCode", langCode);
        this.update.add("langCode");
    }

    public String getMobile() {
        return (String)this.data.get("mobile");
    }

    public void setMobile(String mobile) {
        this.data.put("mobile", mobile);
        this.update.add("mobile");
    }

    public String getTimeZone() {
        return (String)this.data.get("timeZone");
    }

    public void setTimeZone(String timeZone) {
        this.data.put("timeZone", timeZone);
        this.update.add("timeZone");
    }

    public String getEmailId() {
        return (String)this.data.get("emailId");
    }

    public void setEmailId(String emailId) {
        this.data.put("emailId", emailId);
        this.update.add("emailId");
    }

    public List<String> getAssociatedChatDepartmentIds() {
        return (List)this.data.get("associatedChatDepartmentIds");
    }

    public void setAssociatedChatDepartmentIds(List<String> associatedChatDepartmentIds) {
        this.data.put("associatedChatDepartmentIds", associatedChatDepartmentIds);
        this.update.add("associatedChatDepartmentIds");
    }

    public String getZuid() {
        return (String)this.data.get("zuid");
    }

    public List<String> getAssociatedDepartmentIds() {
        return (List)this.data.get("associatedDepartmentIds");
    }

    public void setAssociatedDepartmentIds(List<String> associatedDepartmentIds) {
        this.data.put("associatedDepartmentIds", associatedDepartmentIds);
        this.update.add("associatedDepartmentIds");
    }

    public String getPhotoURL() {
        return (String)this.data.get("photoURL");
    }

    public String getFirstName() {
        return (String)this.data.get("firstName");
    }

    public void setFirstName(String firstName) {
        this.data.put("firstName", firstName);
        this.update.add("firstName");
    }

    public String getPhone() {
        return (String)this.data.get("phone");
    }

    public void setPhone(String phone) {
        this.data.put("phone", phone);
        this.update.add("phone");
    }

    public String getProfileId() {
        return (String)this.data.get("profileId");
    }

    public String getCountryCode() {
        return (String)this.data.get("countryCode");
    }

    public void setCountryCode(String countryCode) {
        this.data.put("countryCode", countryCode);
        this.update.add("countryCode");
    }

    public List<String> getChannelExpert() {
        return (List)this.data.get("channelExpert");
    }

    public void setChannelExpert(List<String> channelExpert) {
        this.data.put("channelExpert", channelExpert);
        this.update.add("channelExpert");
    }

    public String getName() {
        return (String)this.data.get("name");
    }

    public RolePermissionType getRolePermissionType() {
        String responseValue = (String)this.data.get("rolePermissionType");
        RolePermissionType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Light": {
                value = RolePermissionType.LIGHT;
                break;
            }
            case "AgentPublic": {
                value = RolePermissionType.AGENTPUBLIC;
                break;
            }
            case "Custom": {
                value = RolePermissionType.CUSTOM;
                break;
            }
            case "AgentPersonal": {
                value = RolePermissionType.AGENTPERSONAL;
                break;
            }
            case "Admin": {
                value = RolePermissionType.ADMIN;
            }
        }
        return value;
    }

    public void setRolePermissionType(RolePermissionType rolePermissionType) {
        String value = null;
        if (rolePermissionType != null) {
            value = rolePermissionType.getValue();
        }
        this.data.put("rolePermissionType", value);
        this.update.add("rolePermissionType");
    }

    public Boolean getIsConfirmed() {
        return (Boolean)this.data.get("isConfirmed");
    }

    public String getAboutInfo() {
        return (String)this.data.get("aboutInfo");
    }

    public void setAboutInfo(String aboutInfo) {
        this.data.put("aboutInfo", aboutInfo);
        this.update.add("aboutInfo");
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public Status getStatus() {
        String responseValue = (String)this.data.get("status");
        Status value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "DISABLED": {
                value = Status.DISABLED;
                break;
            }
            case "ACTIVE": {
                value = Status.ACTIVE;
            }
        }
        return value;
    }

    public void setStatus(Status status) {
        String value = null;
        if (status != null) {
            value = status.getValue();
        }
        this.data.put("status", value);
        this.update.add("status");
    }

    public List<Department> getAssociatedChatDepartments() {
        return (List)this.data.get("associatedChatDepartments");
    }

    public Role getRole() {
        return (Role)this.data.get("role");
    }

    public Profile getProfile() {
        return (Profile)this.data.get("profile");
    }

    public List<Department> getAssociatedDepartments() {
        return (List)this.data.get("associatedDepartments");
    }

    private void setFieldValues(JSONObject agentData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(agentData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = agentData.get(key);
            if (agentData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, agentData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject agentData) throws JSONException {
        int i;
        JSONArray array;
        if (agentData.has("associatedChatDepartments")) {
            if (agentData.isNull("associatedChatDepartments")) {
                this.data.put("associatedChatDepartments", null);
                agentData.remove("associatedChatDepartments");
            } else {
                ArrayList<Department> associatedChatDepartmentsList = new ArrayList<Department>();
                array = agentData.getJSONArray("associatedChatDepartments");
                for (i = 0; i < array.length(); ++i) {
                    Department associatedChatDepartments = new Department(array.getJSONObject(i));
                    associatedChatDepartmentsList.add(associatedChatDepartments);
                }
                this.data.put("associatedChatDepartments", associatedChatDepartmentsList);
                agentData.remove("associatedChatDepartments");
            }
        }
        if (agentData.has("role")) {
            if (agentData.isNull("role")) {
                this.data.put("role", null);
                agentData.remove("role");
            } else {
                Role role = new Role(agentData.getJSONObject("role"));
                this.data.put("role", role);
                agentData.remove("role");
            }
        }
        if (agentData.has("profile")) {
            if (agentData.isNull("profile")) {
                this.data.put("profile", null);
                agentData.remove("profile");
            } else {
                Profile profile = new Profile(agentData.getJSONObject("profile"));
                this.data.put("profile", profile);
                agentData.remove("profile");
            }
        }
        if (agentData.has("associatedDepartments")) {
            if (agentData.isNull("associatedDepartments")) {
                this.data.put("associatedDepartments", null);
                agentData.remove("associatedDepartments");
            } else {
                ArrayList<Department> associatedDepartmentsList = new ArrayList<Department>();
                array = agentData.getJSONArray("associatedDepartments");
                for (i = 0; i < array.length(); ++i) {
                    Department associatedDepartments = new Department(array.getJSONObject(i));
                    associatedDepartmentsList.add(associatedDepartments);
                }
                this.data.put("associatedDepartments", associatedDepartmentsList);
                agentData.remove("associatedDepartments");
            }
        }
        return agentData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Status {
        DISABLED("DISABLED"),
        ACTIVE("ACTIVE");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RolePermissionType {
        LIGHT("Light"),
        AGENTPUBLIC("AgentPublic"),
        CUSTOM("Custom"),
        AGENTPERSONAL("AgentPersonal"),
        ADMIN("Admin");

        private String value;

        private RolePermissionType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

