/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.activity;

import com.zoho.desk.activity.Activity;
import com.zoho.desk.activity.GetTicketActivitiesFilter;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityAPI {
    private String mailId;

    private ActivityAPI(String mailId) {
        this.mailId = mailId;
    }

    public static ActivityAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new ActivityAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public List<Activity> getTicketActivities(String ticketId, Integer from, Integer limit, APIConstants.Activity.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Activity.Include> includeSet, GetTicketActivitiesFilter filter) {
        if (ticketId == null) {
            throw new ZDeskException("ticketId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/tickets/" + ticketId + "/activities");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Activity.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Activity> activityData = new ArrayList<Activity>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Activity activityRef = new Activity(dataArray.getJSONObject(i));
                    activityData.add(activityRef);
                }
            }
            ArrayList<Activity> arrayList = activityData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

