/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.activity;

import com.zoho.desk.agent.Agent;
import com.zoho.desk.contact.Contact;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.team.Team;
import com.zoho.desk.ticket.Ticket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Activity {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isCommented");

    public Activity() {
    }

    public Activity(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public String getContactId() {
        return (String)this.data.get("contactId");
    }

    public Date getCompletedTime() throws ZDeskException {
        try {
            String completedTimeValue = (String)this.data.get("completedTime");
            return completedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(completedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getSubject() {
        return (String)this.data.get("subject");
    }

    public String getDepartmentId() {
        return (String)this.data.get("departmentId");
    }

    public Date getDueDate() throws ZDeskException {
        try {
            String dueDateValue = (String)this.data.get("dueDate");
            return dueDateValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(dueDateValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getCreatorId() {
        return (String)this.data.get("creatorId");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public String getPriority() {
        return (String)this.data.get("priority");
    }

    public Boolean getIsCommented() {
        return (Boolean)this.data.get("isCommented");
    }

    public String getWebUrl() {
        return (String)this.data.get("webUrl");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public Date getStartTime() throws ZDeskException {
        try {
            String startTimeValue = (String)this.data.get("startTime");
            return startTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(startTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public ActivityType getActivityType() {
        String responseValue = (String)this.data.get("activityType");
        ActivityType value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Tasks": {
                value = ActivityType.TASKS;
                break;
            }
            case "Events": {
                value = ActivityType.EVENTS;
                break;
            }
            case "Calls": {
                value = ActivityType.CALLS;
            }
        }
        return value;
    }

    public String getCategory() {
        return (String)this.data.get("category");
    }

    public String getTicketId() {
        return (String)this.data.get("ticketId");
    }

    public Status getStatus() {
        String responseValue = (String)this.data.get("status");
        Status value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "Scheduled": {
                value = Status.SCHEDULED;
                break;
            }
            case "Completed": {
                value = Status.COMPLETED;
                break;
            }
            case "Missed": {
                value = Status.MISSED;
                break;
            }
            case "In Progress": {
                value = Status.INPROGRESS;
                break;
            }
            case "Canceled": {
                value = Status.CANCELED;
            }
        }
        return value;
    }

    public Direction getDirection() {
        String responseValue = (String)this.data.get("direction");
        Direction value = null;
        if (responseValue == null) {
            return value;
        }
        switch (responseValue) {
            case "outbound": {
                value = Direction.OUTBOUND;
                break;
            }
            case "inbound": {
                value = Direction.INBOUND;
            }
        }
        return value;
    }

    public Ticket getTicket() {
        return (Ticket)this.data.get("ticket");
    }

    public Contact getContact() {
        return (Contact)this.data.get("contact");
    }

    public Agent getAssignee() {
        return (Agent)this.data.get("assignee");
    }

    public Team getTeam() {
        return (Team)this.data.get("team");
    }

    private void setFieldValues(JSONObject activityData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(activityData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = activityData.get(key);
            if (activityData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, activityData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject activityData) throws JSONException {
        if (activityData.has("ticket")) {
            if (activityData.isNull("ticket")) {
                this.data.put("ticket", null);
                activityData.remove("ticket");
            } else {
                Ticket ticket = new Ticket(activityData.getJSONObject("ticket"));
                this.data.put("ticket", ticket);
                activityData.remove("ticket");
            }
        }
        if (activityData.has("contact")) {
            if (activityData.isNull("contact")) {
                this.data.put("contact", null);
                activityData.remove("contact");
            } else {
                Contact contact = new Contact(activityData.getJSONObject("contact"));
                this.data.put("contact", contact);
                activityData.remove("contact");
            }
        }
        if (activityData.has("assignee")) {
            if (activityData.isNull("assignee")) {
                this.data.put("assignee", null);
                activityData.remove("assignee");
            } else {
                Agent assignee = new Agent(activityData.getJSONObject("assignee"));
                this.data.put("assignee", assignee);
                activityData.remove("assignee");
            }
        }
        if (activityData.has("team")) {
            if (activityData.isNull("team")) {
                this.data.put("team", null);
                activityData.remove("team");
            } else {
                Team team = new Team(activityData.getJSONObject("team"));
                this.data.put("team", team);
                activityData.remove("team");
            }
        }
        return activityData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum Direction {
        OUTBOUND("outbound"),
        INBOUND("inbound");

        private String value;

        private Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        SCHEDULED("Scheduled"),
        COMPLETED("Completed"),
        MISSED("Missed"),
        INPROGRESS("In Progress"),
        CANCELED("Canceled");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ActivityType {
        TASKS("Tasks"),
        EVENTS("Events"),
        CALLS("Calls");

        private String value;

        private ActivityType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

