/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.account;

import com.zoho.desk.account.Account;
import com.zoho.desk.account.GetAccountsFilter;
import com.zoho.desk.account.GetContactsUnderAccountFilter;
import com.zoho.desk.account.GetTicketsByAccountFilter;
import com.zoho.desk.contact.Contact;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.http.HttpClient;
import com.zoho.desk.init.APIConstants;
import com.zoho.desk.ticket.Ticket;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountAPI {
    private String mailId;

    private AccountAPI(String mailId) {
        this.mailId = mailId;
    }

    public static AccountAPI getInstance(String mailId) {
        if (mailId == null) {
            throw new ZDeskException("Give a valid mailId.");
        }
        return new AccountAPI(mailId);
    }

    public String getMailId() {
        return this.mailId;
    }

    public boolean moveToTrash(List<String> accountIds) {
        if (accountIds == null) {
            throw new ZDeskException("accountIds is mandatory payload key");
        }
        HashMap<String, List<String>> inputData = new HashMap<String, List<String>>();
        inputData.put("accountIds", accountIds);
        JSONObject payloadData = new JSONObject(inputData);
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/moveToTrash");
        try {
            InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(payloadData.toString().getBytes("UTF-8")), this.mailId);
            responseStream.close();
            return true;
        }
        catch (RuntimeException ex) {
            return false;
        }
        catch (IOException ex) {
            throw new ZDeskException(ex);
        }
    }

    public List<Ticket> getTicketsByAccount(String accountId, Integer from, Integer limit, APIConstants.Account.SortBy sortBy, boolean isAscending, EnumSet<APIConstants.Account.Include> includeSet, GetTicketsByAccountFilter filter) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/tickets");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Account.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            String value = includeStr.toString();
            requestURL.append(value.substring(0, value.length() - 1));
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Ticket> ticketData = new ArrayList<Ticket>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Ticket ticketRef = new Ticket(dataArray.getJSONObject(i));
                    ticketData.add(ticketRef);
                }
            }
            ArrayList<Ticket> arrayList = ticketData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Account> getAccounts(Integer from, Integer limit, APIConstants.Account.SortBy sortBy, boolean isAscending, GetAccountsFilter filter) {
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Account> accountData = new ArrayList<Account>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Account accountRef = new Account(dataArray.getJSONObject(i));
                    accountData.add(accountRef);
                }
            }
            ArrayList<Account> arrayList = accountData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Account createAccount(Account account) {
        if (account.getAccountName() == null) {
            throw new ZDeskException("accountName is mandatory payload key");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts");
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.POST, requestURL.toString(), (HttpEntity)new ByteArrayEntity(account.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Account account2 = new Account(new JSONObject(responseData));
            return account2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Account updateAccount(String accountId, Account account) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId);
        InputStream responseStream = null;
        try {
            responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.PATCH, requestURL.toString(), (HttpEntity)new ByteArrayEntity(account.getPayloadForUpdate().toString().getBytes("UTF-8")), this.mailId);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZDeskException(e);
        }
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            Account account2 = new Account(new JSONObject(responseData));
            return account2;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Account> getAccountsUnderProduct(String productId, Integer from, Integer limit, APIConstants.Account.SortBy sortBy, boolean isAscending) {
        if (productId == null) {
            throw new ZDeskException("productId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/products/" + productId + "/accounts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Account> accountData = new ArrayList<Account>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Account accountRef = new Account(dataArray.getJSONObject(i));
                    accountData.add(accountRef);
                }
            }
            ArrayList<Account> arrayList = accountData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public Account getAccount(String accountId, EnumSet<APIConstants.Account.Include> includeSet) {
        Object value;
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId);
        if (includeSet != null) {
            String includeQueryStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(includeQueryStr).append("include=");
            StringBuilder includeStr = new StringBuilder();
            for (APIConstants.Account.Include data : includeSet) {
                includeStr.append(data.getValue());
                includeStr.append(",");
            }
            value = includeStr.toString();
            requestURL.append(((String)value).substring(0, ((String)value).length() - 1));
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            value = new Account(new JSONObject(responseData));
            return value;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }

    public List<Contact> getContactsUnderAccount(String accountId, Integer from, Integer limit, APIConstants.Account.SortBy sortBy, boolean isAscending, GetContactsUnderAccountFilter filter) {
        if (accountId == null) {
            throw new ZDeskException("accountId is mandatory PathParam");
        }
        StringBuilder requestURL = new StringBuilder("/api/v1/accounts/" + accountId + "/contacts");
        if (from != null) {
            requestURL = requestURL.append("?from=").append(from);
        }
        if (limit != null) {
            String limitStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(limitStr).append("limit=").append(limit);
        }
        if (sortBy != null) {
            String sortByQueryStr = requestURL.toString().indexOf("?") == -1 ? "?" : "&";
            requestURL.append(sortByQueryStr).append("sortBy=");
            if (!isAscending) {
                requestURL.append("-");
            }
            requestURL.append(sortBy.getValue());
        }
        if (filter != null) {
            String filterStr = requestURL.toString().indexOf("?") != -1 ? "&" : "?";
            requestURL.append(filterStr).append(filter.toString());
        }
        InputStream responseStream = HttpClient.getInstance().callAPI(APIConstants.HttpMethods.GET, requestURL.toString(), null, this.mailId);
        String responseData = new Scanner(responseStream).useDelimiter("\\A").next();
        try {
            JSONObject data = new JSONObject(responseData);
            ArrayList<Contact> contactData = new ArrayList<Contact>();
            Iterator itr = data.keys();
            if (itr.hasNext()) {
                JSONArray dataArray = data.getJSONArray((String)itr.next());
                for (int i = 0; i < dataArray.length(); ++i) {
                    Contact contactRef = new Contact(dataArray.getJSONObject(i));
                    contactData.add(contactRef);
                }
            }
            ArrayList<Contact> arrayList = contactData;
            return arrayList;
        }
        catch (JSONException ex) {
            throw new ZDeskException((Exception)((Object)ex));
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException e) {
                throw new ZDeskException(e);
            }
        }
    }
}

