/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.account;

import com.zoho.desk.account.CustomerHappiness;
import com.zoho.desk.account.ZohoCRMAccount;
import com.zoho.desk.agent.Agent;
import com.zoho.desk.contact.Contact;
import com.zoho.desk.department.Department;
import com.zoho.desk.exception.ZDeskException;
import com.zoho.desk.init.CommonUtil;
import com.zoho.desk.logger.ZDLogger;
import com.zoho.desk.product.Product;
import com.zoho.desk.team.Team;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Account {
    private Map<String, Object> data = new HashMap<String, Object>();
    private Set<String> update = new HashSet<String>();
    private List<String> booleanValues = Arrays.asList("isDeleted", "isTrashed", "isFollowing");

    public Account() {
    }

    public Account(JSONObject data) throws JSONException {
        this.setFieldValues(data);
    }

    public Date getModifiedTime() throws ZDeskException {
        try {
            String modifiedTimeValue = (String)this.data.get("modifiedTime");
            return modifiedTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(modifiedTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getCountry() {
        return (String)this.data.get("country");
    }

    public void setCountry(String country) {
        this.data.put("country", country);
        this.update.add("country");
    }

    public String getCode() {
        return (String)this.data.get("code");
    }

    public void setCode(String code) {
        this.data.put("code", code);
        this.update.add("code");
    }

    public String getAccountName() {
        return (String)this.data.get("accountName");
    }

    public void setAccountName(String accountName) {
        this.data.put("accountName", accountName);
        this.update.add("accountName");
    }

    public List<String> getAssociatedSLAIds() {
        return (List)this.data.get("associatedSLAIds");
    }

    public void setAssociatedSLAIds(List<String> associatedSLAIds) {
        this.data.put("associatedSLAIds", associatedSLAIds);
        this.update.add("associatedSLAIds");
    }

    public String getCity() {
        return (String)this.data.get("city");
    }

    public void setCity(String city) {
        this.data.put("city", city);
        this.update.add("city");
    }

    public String getDescription() {
        return (String)this.data.get("description");
    }

    public void setDescription(String description) {
        this.data.put("description", description);
        this.update.add("description");
    }

    public ZohoCRMAccount getZohoCRMAccount() {
        try {
            Map value = (Map)this.data.get("zohoCRMAccount");
            if (value == null) {
                return null;
            }
            return new ZohoCRMAccount(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getIndustry() {
        return (String)this.data.get("industry");
    }

    public void setIndustry(String industry) {
        this.data.put("industry", industry);
        this.update.add("industry");
    }

    public String getOwnerId() {
        return (String)this.data.get("ownerId");
    }

    public void setOwnerId(String ownerId) {
        this.data.put("ownerId", ownerId);
        this.update.add("ownerId");
    }

    public Boolean getIsDeleted() {
        return (Boolean)this.data.get("isDeleted");
    }

    public Boolean getIsTrashed() {
        return (Boolean)this.data.get("isTrashed");
    }

    public String getStreet() {
        return (String)this.data.get("street");
    }

    public void setStreet(String street) {
        this.data.put("street", street);
        this.update.add("street");
    }

    public String getAnnualrevenue() {
        return (String)this.data.get("annualrevenue");
    }

    public void setAnnualrevenue(String annualrevenue) {
        this.data.put("annualrevenue", annualrevenue);
        this.update.add("annualrevenue");
    }

    public Date getCreatedTime() throws ZDeskException {
        try {
            String createdTimeValue = (String)this.data.get("createdTime");
            return createdTimeValue != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(createdTimeValue) : null;
        }
        catch (ParseException ex) {
            throw new ZDeskException(ex);
        }
    }

    public String getId() {
        return (String)this.data.get("id");
    }

    public CustomerHappiness getCustomerHappiness() {
        try {
            Map value = (Map)this.data.get("customerHappiness");
            if (value == null) {
                return null;
            }
            return new CustomerHappiness(new JSONObject(value));
        }
        catch (JSONException ex) {
            ZDLogger.logError(ex);
            return null;
        }
    }

    public String getState() {
        return (String)this.data.get("state");
    }

    public void setState(String state) {
        this.data.put("state", state);
        this.update.add("state");
    }

    public String getFax() {
        return (String)this.data.get("fax");
    }

    public void setFax(String fax) {
        this.data.put("fax", fax);
        this.update.add("fax");
    }

    public String getEmail() {
        return (String)this.data.get("email");
    }

    public void setEmail(String email) {
        this.data.put("email", email);
        this.update.add("email");
    }

    public String getWebsite() {
        return (String)this.data.get("website");
    }

    public void setWebsite(String website) {
        this.data.put("website", website);
        this.update.add("website");
    }

    public Boolean getIsFollowing() {
        return (Boolean)this.data.get("isFollowing");
    }

    public Long getCfFieldAsLong(String label) {
        try {
            return this.getCf(label) != null ? Long.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Double getCfFieldAsDouble(String label) {
        try {
            return this.getCf(label) != null ? Double.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Integer getCfFieldAsInteger(String label) {
        try {
            return this.getCf(label) != null ? Integer.valueOf(this.getCf(label)) : null;
        }
        catch (NumberFormatException ex) {
            ZDLogger.logError(label + " value is not a Number");
            return null;
        }
    }

    public Boolean getCfFieldAsBoolean(String label) {
        return this.getCf(label) != null ? Boolean.valueOf(this.getCf(label)) : null;
    }

    public List<String> getCfFieldAsList(String label) {
        return this.getCf(label) != null ? Arrays.asList(this.getCf(label).split(";")) : null;
    }

    public String getCf(String label) {
        Map cf;
        if (this.data.containsKey("cf") && (cf = (Map)this.data.get("cf")).containsKey(label)) {
            if (cf.get(label) != null) {
                return (String)cf.get(label);
            }
            return null;
        }
        return null;
    }

    public void setCf(String key, String value) {
        HashMap<String, String> cf = (HashMap<String, String>)this.data.get("cf");
        if (cf == null) {
            cf = new HashMap<String, String>();
        }
        cf.put(key, value);
        this.data.put("cf", cf);
        this.update.add("cf");
    }

    public String getPhone() {
        return (String)this.data.get("phone");
    }

    public void setPhone(String phone) {
        this.data.put("phone", phone);
        this.update.add("phone");
    }

    public String getWebUrl() {
        return (String)this.data.get("webUrl");
    }

    public Agent getOwner() {
        return (Agent)this.data.get("owner");
    }

    public Product getProduct() {
        return (Product)this.data.get("product");
    }

    public Contact getContact() {
        return (Contact)this.data.get("contact");
    }

    public Boolean getIsRead() {
        return (Boolean)this.data.get("isRead");
    }

    public Team getTeam() {
        return (Team)this.data.get("team");
    }

    public Agent getAssignee() {
        return (Agent)this.data.get("assignee");
    }

    public Department getDepartment() {
        return (Department)this.data.get("department");
    }

    private void setFieldValues(JSONObject accountData) throws JSONException {
        Iterator itr = this.handleIncludeQueryParamsFields(accountData).keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = accountData.get(key);
            if (accountData.isNull(key)) {
                this.data.put(key, null);
                continue;
            }
            if (this.booleanValues.contains(key)) {
                this.data.put(key, accountData.getBoolean(key));
                continue;
            }
            value = value instanceof JSONObject ? CommonUtil.toConvertJSONToMap((JSONObject)value) : (value instanceof JSONArray ? CommonUtil.toConvertJSONToList((JSONArray)value) : String.valueOf(value));
            this.data.put(key, value);
        }
    }

    private JSONObject handleIncludeQueryParamsFields(JSONObject accountData) throws JSONException {
        if (accountData.has("owner")) {
            if (accountData.isNull("owner")) {
                this.data.put("owner", null);
                accountData.remove("owner");
            } else {
                Agent owner = new Agent(accountData.getJSONObject("owner"));
                this.data.put("owner", owner);
                accountData.remove("owner");
            }
        }
        if (accountData.has("product")) {
            if (accountData.isNull("product")) {
                this.data.put("product", null);
                accountData.remove("product");
            } else {
                Product product = new Product(accountData.getJSONObject("product"));
                this.data.put("product", product);
                accountData.remove("product");
            }
        }
        if (accountData.has("contact")) {
            if (accountData.isNull("contact")) {
                this.data.put("contact", null);
                accountData.remove("contact");
            } else {
                Contact contact = new Contact(accountData.getJSONObject("contact"));
                this.data.put("contact", contact);
                accountData.remove("contact");
            }
        }
        if (accountData.has("team")) {
            if (accountData.isNull("team")) {
                this.data.put("team", null);
                accountData.remove("team");
            } else {
                Team team = new Team(accountData.getJSONObject("team"));
                this.data.put("team", team);
                accountData.remove("team");
            }
        }
        if (accountData.has("assignee")) {
            if (accountData.isNull("assignee")) {
                this.data.put("assignee", null);
                accountData.remove("assignee");
            } else {
                Agent assignee = new Agent(accountData.getJSONObject("assignee"));
                this.data.put("assignee", assignee);
                accountData.remove("assignee");
            }
        }
        if (accountData.has("department")) {
            if (accountData.isNull("department")) {
                this.data.put("department", null);
                accountData.remove("department");
            } else {
                Department department = new Department(accountData.getJSONObject("department"));
                this.data.put("department", department);
                accountData.remove("department");
            }
        }
        return accountData;
    }

    JSONObject getPayloadForUpdate() {
        HashMap<String, Object> payloadData = new HashMap<String, Object>();
        for (String key : this.update) {
            payloadData.put(key, this.data.get(key));
        }
        return new JSONObject(payloadData);
    }

    public String toString() {
        return this.data.toString();
    }
}

